/*
 * Decompiled with CFR 0.152.
 */
package mynotebook;

import fof.file.FOFile;
import fof.file.FOFileMgr;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JFrame;
import mynotebook.bo.notebook.BONotebookEncoder;
import mynotebook.bo.user.BOUserMgr;
import mynotebook.controller.NotebookController;
import mynotebook.model.NotebookModel;
import mynotebook.view.NotebookPanel;

public class MyNotebook {
    private static final boolean bDebug = false;
    private final BOUserMgr objUserMgr;

    public static void consoleOutput(String strOutput) {
    }

    private static BOUserMgr initUserBO(FOFileMgr objFileMgr) {
        if (objFileMgr == null) {
            return null;
        }
        FOFile objUserFile = new FOFile();
        objUserFile.setFileName("system.mnb");
        objUserFile.setFileDirectory("mnb-system");
        BOUserMgr objUserMgr = new BOUserMgr(objFileMgr, objUserFile);
        objUserMgr.initFile();
        if (!objFileMgr.verifyFilePath(objUserMgr.getFile())) {
            MyNotebook.consoleOutput("MyNotebook : initUserBO : verifyFilePath failed.");
            objUserMgr = null;
        }
        if (objUserMgr != null) {
            if (objFileMgr.verifyFileExists(objUserMgr.getFile())) {
                try {
                    objUserMgr.parseBusinessObjects();
                }
                catch (IOException ex) {
                    MyNotebook.consoleOutput("MyNotebook : initUserBO : parseBusinessObjects failed.");
                    MyNotebook.consoleOutput(ex.toString());
                    objUserMgr = null;
                }
            } else {
                MyNotebook.consoleOutput("MyNotebook : initUserBO : Missing system.mnb file. First time to run MyNoteBook in this working directory.");
                objUserMgr.initSeqs();
            }
        }
        return objUserMgr;
    }

    public MyNotebook() {
        FOFileMgr objFileMgr = new FOFileMgr(System.getProperty("user.dir"));
        objFileMgr.setEncoder(new BONotebookEncoder());
        this.objUserMgr = MyNotebook.initUserBO(objFileMgr);
        if (this.objUserMgr != null) {
            this.objUserMgr.createAdminUser();
            if (this.objUserMgr.isAnyUserAdmin()) {
                this.objUserMgr.disableAdminUser();
            }
        } else {
            MyNotebook.consoleOutput("MyNotebook : main : Initialization failed, exiting...");
            System.exit(0);
        }
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        NotebookController nc = new NotebookController();
        NotebookModel nm = new NotebookModel(this.objUserMgr);
        NotebookPanel nbp = new NotebookPanel(nc, objFileMgr.getFOFVersion());
        nc.addView(nbp);
        nc.addModel(nm);
        JFrame displayFrame = new JFrame("My Notebook");
        displayFrame.getContentPane().add((Component)nbp, "Center");
        displayFrame.setDefaultCloseOperation(3);
        displayFrame.pack();
        displayFrame.setLocationRelativeTo(null);
        displayFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                try {
                    MyNotebook.this.objUserMgr.persistBusinessObjects();
                }
                catch (IOException ex) {
                    MyNotebook.consoleOutput("MyNotebook : main : windowClosing persistBusinessObjects() for User BO failed.");
                    MyNotebook.consoleOutput(ex.toString());
                }
                MyNotebook.consoleOutput("MyNotebook : main :  windowClosing");
            }
        });
        displayFrame.setVisible(true);
        nm.initDefault();
    }

    public static void main(String[] args) {
        MyNotebook main = new MyNotebook();
    }
}

