/*
 * Decompiled with CFR 0.152.
 */
package mynotebook.bo.note;

import fof.bo.BusinessObject;
import fof.bo.BusinessObjectMgr;
import fof.bo.BusinessObjectSequence;
import fof.file.FOFile;
import fof.file.FOFileMgr;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import mynotebook.MyNotebook;
import mynotebook.bo.note.BONote;
import mynotebook.bo.note.BONoteEncoded;
import mynotebook.bo.note.BONoteValidate;
import mynotebook.bo.note.BONotebookNote;

public class BONoteMgr
extends BusinessObjectMgr {
    private BusinessObjectSequence objNoteSeq;
    private BONote objSelectedNote;
    private static final String strNoteSeqName = "Note_SEQ";
    private static final String strNoteLineType = "NBNO";
    private static final String strEncodedNoteLineType = "NBEN";
    private static final String strSeqLineType = "SEQC";
    private final BONoteValidate objNoteValidate = new BONoteValidate();

    public BONoteMgr() {
    }

    public BONoteMgr(FOFileMgr objFileMgr, FOFile objFile) {
        super(objFileMgr, objFile);
    }

    public void addSequence(String strSeqName, String strSeqStart, String strSeqMax, String strSeqIncr, String strSeqValue) {
        BusinessObjectSequence objBO = this.getSeq(strSeqName);
        if (objBO == null) {
            objBO = new BusinessObjectSequence(strSeqLineType);
            objBO.setSeqName(strSeqName);
            objBO.setSeqStart(strSeqStart);
            objBO.setSeqMax(strSeqMax);
            objBO.setSeqIncr(strSeqIncr);
            objBO.setSeqValue(strSeqValue);
            this.addBusinessObject(objBO);
        }
    }

    public ArrayList<BusinessObjectSequence> getSequences() {
        ArrayList<BusinessObjectSequence> aSequences = new ArrayList<BusinessObjectSequence>();
        ArrayList<BusinessObject> aBusinessObjs = super.getBusinessObjectsOfLineType(strSeqLineType);
        for (BusinessObject objBusinessObj : aBusinessObjs) {
            BusinessObjectSequence objBO = (BusinessObjectSequence)objBusinessObj;
            aSequences.add(objBO);
        }
        return aSequences;
    }

    public BusinessObjectSequence getSeq(String strSeqName) {
        BusinessObjectSequence objSeq = null;
        ArrayList<BusinessObjectSequence> aSequences = this.getSequences();
        for (BusinessObjectSequence objBO : aSequences) {
            if (!objBO.getSeqName().equals(strSeqName)) continue;
            objSeq = objBO;
            break;
        }
        return objSeq;
    }

    public BusinessObjectSequence getNoteSeq() {
        if (this.objNoteSeq == null) {
            this.objNoteSeq = this.getSeq(strNoteSeqName);
        }
        return this.objNoteSeq;
    }

    public BONote addNote(String strName, String strAuthor, String strTab, String strKeyWords, String strAttachments, String strDateCreated, String strDateModified, String strEntry, String strNotebookNoteID) {
        BONote objBO = new BONote(strNoteLineType);
        objBO.setNoteID(strNotebookNoteID);
        objBO.setName(strName);
        objBO.setAuthor(strAuthor);
        objBO.setTab(strTab);
        objBO.setKeyWords(strKeyWords);
        objBO.setAttachments(strAttachments);
        objBO.setDateCreated(strDateCreated);
        objBO.setDateModified(strDateModified);
        objBO.setEntry(strEntry);
        this.addBusinessObject(objBO);
        return objBO;
    }

    public void addNote(BONote objNote) {
        objNote.setNoteID(this.getNextNoteID());
        this.addBusinessObject(objNote);
    }

    public void addEncodedNote(String strName, String strAuthor, String strTab, String strKeyWords, String strAttachments, String strDateCreated, String strDateModified, String strEntry) {
        BONoteEncoded objBO = new BONoteEncoded(strEncodedNoteLineType);
        objBO.setNoteID(this.getNextNoteID());
        objBO.setName(strName);
        objBO.setAuthor(strAuthor);
        objBO.setTab(strTab);
        objBO.setKeyWords(strKeyWords);
        objBO.setAttachments(strAttachments);
        objBO.setDateCreated(strDateCreated);
        objBO.setDateModified(strDateModified);
        objBO.setEntry(strEntry);
        this.addBusinessObject(objBO);
        this.setSelectedNote(objBO.getNoteID());
    }

    public void addEncodedNote(BONoteEncoded objNote) {
        objNote.setNoteID(this.getNextNoteID());
        this.addBusinessObject(objNote);
        this.setSelectedNote(objNote.getNoteID());
    }

    public ArrayList<BONote> getNotes() {
        ArrayList<BONote> aNotes = new ArrayList<BONote>();
        ArrayList<BusinessObject> aBusinessObjs = super.getBusinessObjectsOfLineType(strNoteLineType);
        for (BusinessObject objBusinessObj : aBusinessObjs) {
            BONote objBO = (BONote)objBusinessObj;
            aNotes.add(objBO);
        }
        Collections.sort(aNotes);
        return aNotes;
    }

    public ArrayList<BONote> getEncodedNotes() {
        ArrayList<BONote> aNotes = new ArrayList<BONote>();
        ArrayList<BusinessObject> aBusinessObjs = super.getBusinessObjectsOfLineType(strEncodedNoteLineType);
        for (BusinessObject objBusinessObj : aBusinessObjs) {
            BONote objBO = (BONote)objBusinessObj;
            aNotes.add(objBO);
        }
        Collections.sort(aNotes);
        return aNotes;
    }

    public ArrayList<BONote> getAllNotes() {
        BONote objBO;
        ArrayList<BONote> aNotes = new ArrayList<BONote>();
        ArrayList<BusinessObject> aBusinessObjs = super.getBusinessObjectsOfLineType(strNoteLineType);
        for (BusinessObject objBusinessObj : aBusinessObjs) {
            objBO = (BONote)objBusinessObj;
            aNotes.add(objBO);
        }
        aBusinessObjs = super.getBusinessObjectsOfLineType(strEncodedNoteLineType);
        for (BusinessObject objBusinessObj : aBusinessObjs) {
            objBO = (BONote)objBusinessObj;
            aNotes.add(objBO);
        }
        Collections.sort(aNotes);
        return aNotes;
    }

    public int getNumOfNotes() {
        ArrayList<BONote> aNotes = this.getAllNotes();
        return aNotes.size();
    }

    public BONote getNoteByID(String strNoteID) {
        BONote objNote = null;
        ArrayList<BONote> aNotes = this.getAllNotes();
        for (BONote objBO : aNotes) {
            if (!objBO.getNoteID().equals(strNoteID)) continue;
            objNote = objBO;
            break;
        }
        return objNote;
    }

    public BONote getNoteByNotebookNote(BONotebookNote objNotebookNote) {
        BONote objNote = this.getNoteByID(objNotebookNote.getNoteId());
        if (objNote == null) {
            try {
                objNote = this.loadNote(objNotebookNote);
            }
            catch (IOException ex) {
                MyNotebook.consoleOutput("MyNotebook : BONoteMgr.getNoteByNBNote : Note load failed.");
                MyNotebook.consoleOutput(ex.toString());
            }
        }
        return objNote;
    }

    public boolean saveNoteByID(String strNoteID) {
        boolean bSaved = false;
        BONote objNote = this.getNoteByID(strNoteID);
        try {
            if (objNote != null) {
                this.saveNote(objNote);
                bSaved = true;
            }
        }
        catch (IOException ex) {
            MyNotebook.consoleOutput("MyNotebook : BONoteMgr.saveNoteByID() : Note persistance failed.");
            MyNotebook.consoleOutput(ex.toString());
        }
        return bSaved;
    }

    public boolean deleteNoteByID(String strNoteID, boolean bDeleteFromFS) {
        boolean bDeleted = false;
        BONote objNote = this.getNoteByID(strNoteID);
        if (objNote != null) {
            if (bDeleteFromFS && !this.deleteNote(objNote)) {
                MyNotebook.consoleOutput("MyNotebook : BONoteMgr.deleteNoteByID() : Note deletion failed.");
                return bDeleted;
            }
            this.removeBusinessObject(objNote);
            bDeleted = true;
        }
        return bDeleted;
    }

    public boolean deleteNoteByNotebookNote(BONotebookNote objNotebookNote) {
        BONote objShellNote = new BONote();
        objShellNote.setName(objNotebookNote.getName());
        objShellNote.setTab(objNotebookNote.getTab());
        if (!this.deleteNote(objShellNote)) {
            MyNotebook.consoleOutput("MyNotebook : BONoteMgr.deleteNoteByID() : Note deletion failed.");
            return false;
        }
        return true;
    }

    public boolean deleteNoteByIDFromFS(String strNoteId) {
        boolean bDeleteNote = false;
        BONote objNote = this.getNoteByID(strNoteId);
        if (objNote != null) {
            bDeleteNote = this.deleteNote(objNote);
        }
        return bDeleteNote;
    }

    public void setSelectedNote(String strNoteID) {
        this.objSelectedNote = this.getNoteByID(strNoteID);
    }

    public BONote getSelectedNote() {
        return this.objSelectedNote;
    }

    private String getNextNoteID() {
        BusinessObjectSequence objSeq = this.getNoteSeq();
        if (objSeq != null) {
            return objSeq.getNextSeqValue();
        }
        return "0";
    }

    public Map<String, String> getNoteMap() {
        LinkedHashMap<String, String> mNoteList = new LinkedHashMap<String, String>();
        ArrayList<BONote> aNotes = this.getAllNotes();
        for (BONote objBO : aNotes) {
            mNoteList.put(objBO.getNoteID(), objBO.printNote() + "\n");
        }
        return mNoteList;
    }

    public String printNoteHeader() {
        StringBuilder strNoteHeader = new StringBuilder();
        strNoteHeader.append(new BONote("").printNoteHeader()).append("\n");
        return strNoteHeader.toString();
    }

    public String printNotes() {
        StringBuilder strNotes = new StringBuilder();
        ArrayList<BONote> aNotes = this.getAllNotes();
        for (BONote objBO : aNotes) {
            strNotes.append(objBO.printNote()).append("\n");
        }
        return strNotes.toString();
    }

    public boolean validateNote(BONote objNote) {
        this.objNoteValidate.clearValidations();
        return this.objNoteValidate.validate(this.getAllNotes(), this.objSelectedNote, objNote);
    }

    public String getNoteValidationMsg() {
        return this.objNoteValidate.getValidationMsg();
    }

    public BONote createNoteFromEncodedNote(BONoteEncoded objNoteEncoded) {
        BONote objBO = new BONote(strNoteLineType);
        objBO.setNoteID(objNoteEncoded.getNoteID());
        objBO.setName(objNoteEncoded.getName());
        objBO.setAuthor(objNoteEncoded.getAuthor());
        objBO.setTab(objNoteEncoded.getTab());
        objBO.setKeyWords(objNoteEncoded.getKeyWords());
        objBO.setAttachments(objNoteEncoded.getAttachments());
        objBO.setDateCreated(objNoteEncoded.getDateCreated());
        objBO.setDateModified(objNoteEncoded.getDateModified());
        objBO.setEntry(objNoteEncoded.getEntry());
        objBO.setEncoded(true);
        return objBO;
    }

    public BONoteEncoded createEncodedNoteFromNote(BONote objNote) {
        BONoteEncoded objNoteEncoded = new BONoteEncoded(strEncodedNoteLineType);
        objNoteEncoded.setNoteID(objNote.getNoteID());
        objNoteEncoded.setName(objNote.getName());
        objNoteEncoded.setAuthor(objNote.getAuthor());
        objNoteEncoded.setTab(objNote.getTab());
        objNoteEncoded.setKeyWords(objNote.getKeyWords());
        objNoteEncoded.setAttachments(objNote.getAttachments());
        objNoteEncoded.setDateCreated(objNote.getDateCreated());
        objNoteEncoded.setDateModified(objNote.getDateModified());
        objNoteEncoded.setEntry(objNote.getEntry());
        return objNoteEncoded;
    }

    public void clearSelections() {
        this.objSelectedNote = null;
    }

    public ArrayList<String> getLineTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(strSeqLineType);
        return list;
    }

    public void initSeqs() {
        this.addSequence(strNoteSeqName, "0", "99999", "2", "0");
    }

    @Override
    public ArrayList<BusinessObject> getBusinessObjectsOfLineType(String strLineType) {
        ArrayList<BusinessObject> aBusinessObjects = new ArrayList<BusinessObject>();
        switch (strLineType) {
            case "SEQC": {
                ArrayList<BusinessObjectSequence> aSequences = this.getSequences();
                for (BusinessObjectSequence objBO : aSequences) {
                    aBusinessObjects.add(objBO);
                }
                break;
            }
            case "NBNO": {
                ArrayList<BONote> aNotes = this.getNotes();
                for (BONote objBO : aNotes) {
                    aBusinessObjects.add(objBO);
                }
                break;
            }
            case "NBEN": {
                ArrayList<BONote> aNotes = this.getEncodedNotes();
                for (BONote objBO : aNotes) {
                    aBusinessObjects.add(objBO);
                }
                break;
            }
        }
        return aBusinessObjects;
    }

    @Override
    public void initFile() {
        FOFileMgr objFileMgr = this.getFileMgr();
        FOFile objFile = this.getFile();
        objFileMgr.addFileLineToFile(new BusinessObjectSequence(strSeqLineType), objFile);
    }

    @Override
    public void addBusinessObject(String strLineType, Map<String, String> mapAttrValues) {
        switch (strLineType) {
            case "SEQC": {
                BusinessObjectSequence objBO = new BusinessObjectSequence(strLineType);
                objBO.setMapOfAttrValues(mapAttrValues);
                this.addBusinessObject(objBO);
                break;
            }
            case "NBNO": {
                BONote objBO = new BONote(strLineType);
                objBO.setMapOfAttrValues(mapAttrValues);
                this.addBusinessObject(objBO);
                break;
            }
            case "NBEN": {
                BONoteEncoded objBO = new BONoteEncoded(strLineType);
                objBO.setMapOfAttrValues(mapAttrValues);
                this.addBusinessObject(objBO);
                break;
            }
        }
    }

    @Override
    public void persistBusinessObjects() throws IOException {
        FOFileMgr objFileMgr = this.getFileMgr();
        FOFile objFile = this.getFile();
        objFileMgr.writeFile(this, objFile, true, false);
    }

    @Override
    public void parseBusinessObjects() throws IOException {
        FOFileMgr objFileMgr = this.getFileMgr();
        FOFile objFile = this.getFile();
        objFileMgr.readFile(this, objFile);
        this.initSeqs();
    }

    private BONote loadNote(BONotebookNote objNotebookNote) throws IOException {
        FOFileMgr objFileMgr = this.getFileMgr();
        FOFile objNoteFile = new FOFile();
        objNoteFile.setFileName(objNotebookNote.getName() + ".mnt");
        objNoteFile.setFileDirectory("tabs" + File.separator + objNotebookNote.getTab());
        if (!objFileMgr.verifyFilePath(objNoteFile)) {
            MyNotebook.consoleOutput("MyNotebook : BONoteMgr.loadNote : verifyFilePath() for Note BO failed.");
            return null;
        }
        objFileMgr.addFileLineToFile(new BONote(strNoteLineType), objNoteFile);
        objFileMgr.addFileLineToFile(new BONoteEncoded(strEncodedNoteLineType), objNoteFile);
        objFileMgr.readFile(this, objNoteFile);
        BONote objBONote = this.getNoteByID(objNotebookNote.getNoteId());
        if (objBONote.getLineType().equals(strEncodedNoteLineType)) {
            BONote objBOConvertedNote = this.createNoteFromEncodedNote((BONoteEncoded)objBONote);
            this.removeBusinessObject(objBONote);
            this.addBusinessObject(objBOConvertedNote);
        }
        return this.getNoteByID(objNotebookNote.getNoteId());
    }

    private void saveNote(BONote objNote) throws IOException {
        super.clearBusinessObjects();
        if (objNote.isEncoded()) {
            BONoteEncoded objEncodedNote = this.createEncodedNoteFromNote(objNote);
            super.addBusinessObject(objEncodedNote);
        } else {
            super.addBusinessObject(objNote);
        }
        FOFileMgr objFileMgr = this.getFileMgr();
        FOFile objNoteFile = new FOFile();
        objNoteFile.setFileName(objNote.getName() + ".mnt");
        objNoteFile.setFileDirectory("tabs" + File.separator + objNote.getTab());
        if (!objFileMgr.verifyFilePath(objNoteFile)) {
            MyNotebook.consoleOutput("MyNotebook : BONoteMgr.saveNote : verifyFilePath() for Note BO failed.");
            return;
        }
        objFileMgr.addFileLineToFile(new BONote(strNoteLineType), objNoteFile);
        objFileMgr.addFileLineToFile(new BONoteEncoded(strEncodedNoteLineType), objNoteFile);
        objFileMgr.writeFile(this, objNoteFile, true, false);
    }

    private boolean deleteNote(BONote objNote) {
        FOFileMgr objFileMgr = this.getFileMgr();
        String strFileDirectory = objFileMgr.getFilePath() + "tabs" + File.separator + objNote.getTab() + File.separator + objNote.getName() + ".mnt";
        File objFile = new File(strFileDirectory);
        return objFile.delete();
    }
}

