/*
 * Decompiled with CFR 0.152.
 */
package mynotebook.bo.note;

import java.util.ArrayList;
import mynotebook.bo.note.BONote;

public class BONoteValidate {
    private StringBuilder strValidationMsg = null;

    public String getValidationMsg() {
        return this.strValidationMsg.toString();
    }

    public void setValidationMsg(String strValidationMsg) {
        this.strValidationMsg = new StringBuilder().append("Validation Error: ").append(strValidationMsg).append("\n");
    }

    public void addValidationMsg(String strValidationMsg) {
        if (this.strValidationMsg == null) {
            this.setValidationMsg(strValidationMsg);
        } else {
            this.strValidationMsg.append("Validation Error: ").append(strValidationMsg).append("\n");
        }
    }

    public void clearValidations() {
        this.strValidationMsg = null;
    }

    public boolean validate(ArrayList<BONote> aNotes, BONote objSelectedNote, BONote objNote) {
        boolean bValid = true;
        if (this.checkMissingValues(objNote)) {
            this.checkDuplicate(aNotes, objNote);
        }
        if (this.strValidationMsg != null) {
            bValid = false;
        }
        return bValid;
    }

    private boolean checkMissingValues(BONote objNote) {
        boolean bValid = true;
        if (objNote.getName() == null || objNote.getName().isEmpty()) {
            this.addValidationMsg("Name value is missing.");
            bValid = false;
        }
        if (objNote.getAuthor() == null || objNote.getAuthor().isEmpty()) {
            this.addValidationMsg("Author value is missing.");
            bValid = false;
        }
        if (objNote.getTab() == null || objNote.getTab().isEmpty()) {
            this.addValidationMsg("Tab value is missing.");
            bValid = false;
        }
        if (objNote.getKeyWords() == null || objNote.getKeyWords().isEmpty()) {
            this.addValidationMsg("KeyWords value is missing.");
            bValid = false;
        }
        if (objNote.getAttachments() == null || objNote.getAttachments().isEmpty()) {
            this.addValidationMsg("Attachments value is missing.");
            bValid = false;
        }
        if (objNote.getDateCreated() == null || objNote.getDateCreated().isEmpty()) {
            this.addValidationMsg("DateCreated value is missing.");
            bValid = false;
        }
        if (objNote.getDateModified() == null || objNote.getDateModified().isEmpty()) {
            this.addValidationMsg("DateModified value is missing.");
            bValid = false;
        }
        if (objNote.getEntry() == null || objNote.getEntry().isEmpty()) {
            this.addValidationMsg("Entry value is missing.");
            bValid = false;
        }
        return bValid;
    }

    private boolean checkDuplicate(ArrayList<BONote> aNotes, BONote objNote) {
        boolean bValid = true;
        String strName = objNote.getName();
        String strAuthor = objNote.getAuthor();
        String strTab = objNote.getTab();
        String strKeyWords = objNote.getKeyWords();
        String strAttachments = objNote.getAttachments();
        String strDateCreated = objNote.getDateCreated();
        String strDateModified = objNote.getDateModified();
        String strEntry = objNote.getEntry();
        for (BONote objBO : aNotes) {
            if (!objBO.getName().equals(strName) || !objBO.getAuthor().equals(strAuthor) || !objBO.getTab().equals(strTab) || !objBO.getKeyWords().equals(strKeyWords) || !objBO.getAttachments().equals(strAttachments) || !objBO.getDateCreated().equals(strDateCreated) || !objBO.getDateModified().equals(strDateModified) || !objBO.getEntry().equals(strEntry)) continue;
            bValid = false;
            this.addValidationMsg("This business object already exists. ");
        }
        return bValid;
    }
}

