/*
 * Decompiled with CFR 0.152.
 */
package mynotebook.bo.note;

import java.util.ArrayList;
import mynotebook.bo.note.BONotebookNote;

public class BONotebookNoteValidate {
    private StringBuilder strValidationMsg = null;

    public String getValidationMsg() {
        return this.strValidationMsg.toString();
    }

    public void setValidationMsg(String strValidationMsg) {
        this.strValidationMsg = new StringBuilder().append("Validation Error: ").append(strValidationMsg).append("\n");
    }

    public void addValidationMsg(String strValidationMsg) {
        if (this.strValidationMsg == null) {
            this.setValidationMsg(strValidationMsg);
        } else {
            this.strValidationMsg.append("Validation Error: ").append(strValidationMsg).append("\n");
        }
    }

    public void clearValidations() {
        this.strValidationMsg = null;
    }

    public boolean validate(ArrayList<BONotebookNote> aNotebookNotes, BONotebookNote objSelectedNotebookNote, BONotebookNote objNotebookNote) {
        boolean bValid = true;
        if (this.checkMissingValues(objNotebookNote)) {
            this.checkDuplicate(aNotebookNotes, objNotebookNote);
        }
        if (this.strValidationMsg != null) {
            bValid = false;
        }
        return bValid;
    }

    private boolean checkMissingValues(BONotebookNote objNotebookNote) {
        boolean bValid = true;
        if (objNotebookNote.getName() == null || objNotebookNote.getName().isEmpty()) {
            this.addValidationMsg("Name value is missing.");
            bValid = false;
        }
        if (objNotebookNote.getDateCreated() == null || objNotebookNote.getDateCreated().isEmpty()) {
            this.addValidationMsg("DateCreated value is missing.");
            bValid = false;
        }
        if (objNotebookNote.getTab() == null || objNotebookNote.getTab().isEmpty()) {
            this.addValidationMsg("Tab value is missing.");
            bValid = false;
        }
        if (objNotebookNote.getKeyWords() == null || objNotebookNote.getKeyWords().isEmpty()) {
            this.addValidationMsg("KeyWords value is missing.");
            bValid = false;
        }
        if (objNotebookNote.getNoteId() == null || objNotebookNote.getNoteId().isEmpty()) {
            this.addValidationMsg("NoteId value is missing.");
            bValid = false;
        }
        return bValid;
    }

    private boolean checkDuplicate(ArrayList<BONotebookNote> aNotebookNotes, BONotebookNote objNotebookNote) {
        boolean bValid = true;
        String strName = objNotebookNote.getName();
        String strDateCreated = objNotebookNote.getDateCreated();
        String strTab = objNotebookNote.getTab();
        String strKeyWords = objNotebookNote.getKeyWords();
        String strNoteId = objNotebookNote.getNoteId();
        for (BONotebookNote objBO : aNotebookNotes) {
            if (!objBO.getName().equals(strName) || !objBO.getDateCreated().equals(strDateCreated) || !objBO.getTab().equals(strTab) || !objBO.getKeyWords().equals(strKeyWords) || !objBO.getKeyWords().equals(strNoteId)) continue;
            bValid = false;
            this.addValidationMsg("This business object already exists. ");
        }
        return bValid;
    }
}

