/*
 * Decompiled with CFR 0.152.
 */
package mynotebook.bo.notebook;

import fof.bo.BusinessObject;
import java.util.Arrays;
import java.util.Map;
import mynotebook.bo.notebook.BONotebookFormat;

public class BONotebook
extends BusinessObject
implements Comparable {
    private String strNotebookID;
    private static final String strNotebookIDName = "NB_ID";
    private static final int intNotebookIDLength = 10;
    private static final boolean bNotebookIDEncoded = false;
    private String strNotebookName;
    private static final String strNotebookNameName = "NotebookName";
    private static final int intNotebookNameLength = 50;
    private static final boolean bNotebookNameEncoded = false;
    private String strOwner;
    private static final String strOwnerName = "Owner";
    private static final int intOwnerLength = 20;
    private static final boolean bOwnerEncoded = false;
    private final BONotebookFormat objNotebookFormat = new BONotebookFormat();

    public BONotebook() {
    }

    public BONotebook(String strLineType) {
        this.setLineType(strLineType);
    }

    public BONotebook(String strLineType, String strNotebookID, String strNotebookName, String strOwner) {
        this.setLineType(strLineType);
        this.setNotebookID(strNotebookID);
        this.setNotebookName(strNotebookName);
        this.setOwner(strOwner);
    }

    public String getNotebookID() {
        return this.strNotebookID;
    }

    public void setNotebookID(String strNotebookID) {
        this.strNotebookID = this.objNotebookFormat.formatNotebookID(strNotebookID, 10);
    }

    public String getNotebookName() {
        return this.strNotebookName;
    }

    public void setNotebookName(String strNotebookName) {
        this.strNotebookName = this.objNotebookFormat.formatNotebookName(strNotebookName, 50);
    }

    public String getOwner() {
        return this.strOwner;
    }

    public void setOwner(String strOwner) {
        this.strOwner = this.objNotebookFormat.formatOwner(strOwner, 20);
    }

    public String printNotebookHeader() {
        StringBuilder strLine = new StringBuilder();
        strLine.append(this.getFieldString(strNotebookNameName, 50));
        strLine.append(" ");
        strLine.append(this.getFieldString(strOwnerName, 20));
        strLine.append(" ");
        return strLine.toString();
    }

    public String printNotebook() {
        StringBuilder strLine = new StringBuilder();
        strLine.append(this.getFieldString(this.getNotebookName(), 50));
        strLine.append(" ");
        strLine.append(this.getFieldString(this.getOwner(), 20));
        strLine.append(" ");
        return strLine.toString();
    }

    protected String getFieldString(String strValue, int intLength) {
        StringBuilder strFieldString = new StringBuilder("");
        char chFillCh = ' ';
        if (intLength > 0) {
            char[] chArray = new char[intLength];
            Arrays.fill(chArray, chFillCh);
            strFieldString = new StringBuilder(new String(chArray));
            strFieldString.replace(0, strValue.length(), strValue);
        }
        return strFieldString.toString();
    }

    @Override
    public Map<String, Map<String, Object>> getMapOfAttrValues() {
        this.initAttrMap();
        this.addAttrToMap(strNotebookIDName, this.getNotebookID(), 10, this.getNextLineFieldIdx(), false);
        this.addAttrToMap(strNotebookNameName, this.getNotebookName(), 50, this.getNextLineFieldIdx(), false);
        this.addAttrToMap(strOwnerName, this.getOwner(), 20, this.getNextLineFieldIdx(), false);
        return this.getAttrMap();
    }

    @Override
    public void setMapOfAttrValues(Map<String, String> mapAttrValues) {
        for (Map.Entry<String, String> entry : mapAttrValues.entrySet()) {
            String mapKey = entry.getKey();
            String mapValue = entry.getValue();
            switch (mapKey) {
                case "NB_ID": {
                    this.setNotebookID(mapValue);
                    break;
                }
                case "NotebookName": {
                    this.setNotebookName(mapValue);
                    break;
                }
                case "Owner": {
                    this.setOwner(mapValue);
                }
            }
        }
    }

    public int compareTo(Object objNotebook) {
        BONotebook objComp = (BONotebook)objNotebook;
        return this.strNotebookName.compareTo(objComp.getNotebookName());
    }
}

