/*
 * Decompiled with CFR 0.152.
 */
package mynotebook.bo.notebook;

import fof.bo.BusinessObject;
import fof.bo.BusinessObjectMgr;
import fof.bo.BusinessObjectSequence;
import fof.file.FOFile;
import fof.file.FOFileMgr;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import mynotebook.MyNotebook;
import mynotebook.bo.note.BONotebookNote;
import mynotebook.bo.note.BONotebookNoteValidate;
import mynotebook.bo.notebook.BONotebook;
import mynotebook.bo.notebook.BONotebookValidate;
import mynotebook.bo.tab.BONotebookTab;
import mynotebook.bo.tab.BONotebookTabValidate;
import mynotebook.bo.user.BOUser;

public class BONotebookMgr
extends BusinessObjectMgr {
    private BusinessObjectSequence objNotebookSeq;
    private BONotebook objSelectedNotebook;
    private static final String strNotebookSeqName = "NB_SEQ";
    private static final String strNotebookLineType = "NBBK";
    private static final String strSeqLineType = "SEQC";
    private final BONotebookValidate objNotebookValidate = new BONotebookValidate();
    private BusinessObjectSequence objNotebookTabSeq;
    private BONotebookTab objSelectedNotebookTab;
    private static final String strNotebookTabSeqName = "NBTab_SEQ";
    private static final String strNotebookTabLineType = "NBTB";
    private final BONotebookTabValidate objNotebookTabValidate = new BONotebookTabValidate();
    private BusinessObjectSequence objNotebookNoteSeq;
    private BONotebookNote objSelectedNotebookNote;
    private static final String strNotebookNoteSeqName = "NBNote_SEQ";
    private static final String strNotebookNoteLineType = "NBNT";
    private final BONotebookNoteValidate objNotebookNoteValidate = new BONotebookNoteValidate();

    public BONotebookMgr() {
    }

    public BONotebookMgr(FOFileMgr objFileMgr, FOFile objFile) {
        super(objFileMgr, objFile);
    }

    public void addSequence(String strSeqName, String strSeqStart, String strSeqMax, String strSeqIncr, String strSeqValue) {
        BusinessObjectSequence objBO = this.getSeq(strSeqName);
        if (objBO == null) {
            objBO = new BusinessObjectSequence(strSeqLineType);
            objBO.setSeqName(strSeqName);
            objBO.setSeqStart(strSeqStart);
            objBO.setSeqMax(strSeqMax);
            objBO.setSeqIncr(strSeqIncr);
            objBO.setSeqValue(strSeqValue);
            this.addBusinessObject(objBO);
        }
    }

    public ArrayList<BusinessObjectSequence> getSequences() {
        ArrayList<BusinessObjectSequence> aSequences = new ArrayList<BusinessObjectSequence>();
        ArrayList<BusinessObject> aBusinessObjs = super.getBusinessObjectsOfLineType(strSeqLineType);
        for (BusinessObject objBusinessObj : aBusinessObjs) {
            BusinessObjectSequence objBO = (BusinessObjectSequence)objBusinessObj;
            aSequences.add(objBO);
        }
        return aSequences;
    }

    public BusinessObjectSequence getSeq(String strSeqName) {
        BusinessObjectSequence objSeq = null;
        ArrayList<BusinessObjectSequence> aSequences = this.getSequences();
        for (BusinessObjectSequence objBO : aSequences) {
            if (!objBO.getSeqName().equals(strSeqName)) continue;
            objSeq = objBO;
            break;
        }
        return objSeq;
    }

    public BusinessObjectSequence getNotebookSeq() {
        if (this.objNotebookSeq == null) {
            this.objNotebookSeq = this.getSeq(strNotebookSeqName);
        }
        return this.objNotebookSeq;
    }

    public BusinessObjectSequence getNotebookTabSeq() {
        if (this.objNotebookTabSeq == null) {
            this.objNotebookTabSeq = this.getSeq(strNotebookTabSeqName);
        }
        return this.objNotebookTabSeq;
    }

    public BusinessObjectSequence getNotebookNoteSeq() {
        if (this.objNotebookNoteSeq == null) {
            this.objNotebookNoteSeq = this.getSeq(strNotebookNoteSeqName);
        }
        return this.objNotebookNoteSeq;
    }

    public void addNotebook(String strNotebookName, String strOwner) {
        BONotebook objBO = new BONotebook(strNotebookLineType);
        objBO.setNotebookID(this.getNextNotebookID());
        objBO.setNotebookName(strNotebookName);
        objBO.setOwner(strOwner);
        this.addBusinessObject(objBO);
    }

    public ArrayList<BONotebook> getNotebooks() {
        ArrayList<BONotebook> aNotebooks = new ArrayList<BONotebook>();
        ArrayList<BusinessObject> aBusinessObjs = super.getBusinessObjectsOfLineType(strNotebookLineType);
        for (BusinessObject objBusinessObj : aBusinessObjs) {
            BONotebook objBO = (BONotebook)objBusinessObj;
            aNotebooks.add(objBO);
        }
        Collections.sort(aNotebooks);
        return aNotebooks;
    }

    public int getNumOfNotebooks() {
        ArrayList<BONotebook> aNotebooks = this.getNotebooks();
        return aNotebooks.size();
    }

    public BONotebook getNotebookByID(String strNotebookID) {
        BONotebook objNotebook = null;
        ArrayList<BONotebook> aNotebooks = this.getNotebooks();
        for (BONotebook objBO : aNotebooks) {
            if (!objBO.getNotebookID().equals(strNotebookID)) continue;
            objNotebook = objBO;
            break;
        }
        return objNotebook;
    }

    public boolean deleteNotebookByID(String strNotebookID) {
        boolean bDeleted = false;
        BONotebook objNotebook = this.getNotebookByID(strNotebookID);
        if (objNotebook != null) {
            this.removeBusinessObject(objNotebook);
            bDeleted = true;
        }
        return bDeleted;
    }

    public void setSelectedNotebook(String strNotebookID) {
        this.objSelectedNotebook = this.getNotebookByID(strNotebookID);
    }

    public BONotebook getSelectedNotebook() {
        return this.objSelectedNotebook;
    }

    private String getNextNotebookID() {
        BusinessObjectSequence objSeq = this.getNotebookSeq();
        if (objSeq != null) {
            return objSeq.getNextSeqValue();
        }
        return "0";
    }

    public Map<String, String> getNotebookMap() {
        LinkedHashMap<String, String> mNotebookList = new LinkedHashMap<String, String>();
        ArrayList<BONotebook> aNotebooks = this.getNotebooks();
        for (BONotebook objBO : aNotebooks) {
            mNotebookList.put(objBO.getNotebookID(), objBO.printNotebook() + "\n");
        }
        return mNotebookList;
    }

    public String printNotebookHeader() {
        StringBuilder strNotebookHeader = new StringBuilder();
        strNotebookHeader.append(new BONotebook("").printNotebookHeader()).append("\n");
        return strNotebookHeader.toString();
    }

    public String printNotebooks() {
        StringBuilder strNotebooks = new StringBuilder();
        ArrayList<BONotebook> aNotebooks = this.getNotebooks();
        for (BONotebook objBO : aNotebooks) {
            strNotebooks.append(objBO.printNotebook()).append("\n");
        }
        return strNotebooks.toString();
    }

    public boolean validateNotebook(BONotebook objNotebook) {
        this.objNotebookValidate.clearValidations();
        return this.objNotebookValidate.validate(this.getNotebooks(), this.objSelectedNotebook, objNotebook);
    }

    public String getNotebookValidationMsg() {
        return this.objNotebookValidate.getValidationMsg();
    }

    public void addNotebookTab(String strTabName, Boolean bSelected) {
        BONotebookTab objBO = new BONotebookTab(strNotebookTabLineType);
        objBO.setNotebookTabID(this.getNextNotebookTabID());
        objBO.setTabName(strTabName);
        this.addBusinessObject(objBO);
        if (bSelected.booleanValue()) {
            this.setSelectedNotebookTab(objBO.getNotebookTabID());
        }
    }

    public ArrayList<BONotebookTab> getNotebookTabs() {
        ArrayList<BONotebookTab> aNotebookTabs = new ArrayList<BONotebookTab>();
        ArrayList<BusinessObject> aBusinessObjs = super.getBusinessObjectsOfLineType(strNotebookTabLineType);
        for (BusinessObject objBusinessObj : aBusinessObjs) {
            BONotebookTab objBO = (BONotebookTab)objBusinessObj;
            aNotebookTabs.add(objBO);
        }
        Collections.sort(aNotebookTabs);
        return aNotebookTabs;
    }

    public int getNumOfNotebookTabs() {
        ArrayList<BONotebookTab> aNotebookTabs = this.getNotebookTabs();
        return aNotebookTabs.size();
    }

    public BONotebookTab getNotebookTabByID(String strNotebookTabID) {
        BONotebookTab objNotebookTab = null;
        ArrayList<BONotebookTab> aNotebookTabs = this.getNotebookTabs();
        for (BONotebookTab objBO : aNotebookTabs) {
            if (!objBO.getNotebookTabID().equals(strNotebookTabID)) continue;
            objNotebookTab = objBO;
            break;
        }
        return objNotebookTab;
    }

    public boolean deleteNotebookTabByID(String strNotebookTabID, boolean bDeleteFromFS) {
        boolean bDeleted = false;
        BONotebookTab objNotebookTab = this.getNotebookTabByID(strNotebookTabID);
        if (objNotebookTab != null) {
            if (bDeleteFromFS && !this.deleteNotebookTab(objNotebookTab)) {
                MyNotebook.consoleOutput("MyNotebook : BONotebookMgr.deleteNotebookTabByID() : Note deletion failed.");
                return bDeleted;
            }
            this.removeBusinessObject(objNotebookTab);
            bDeleted = true;
        }
        return bDeleted;
    }

    public void setSelectedNotebookTab(String strNotebookTabID) {
        this.objSelectedNotebookTab = this.getNotebookTabByID(strNotebookTabID);
    }

    public BONotebookTab getSelectedNotebookTab() {
        return this.objSelectedNotebookTab;
    }

    private String getNextNotebookTabID() {
        BusinessObjectSequence objSeq = this.getNotebookTabSeq();
        if (objSeq != null) {
            return objSeq.getNextSeqValue();
        }
        return "0";
    }

    public Map<String, String> getNotebookTabMap() {
        LinkedHashMap<String, String> mNotebookTabList = new LinkedHashMap<String, String>();
        ArrayList<BONotebookTab> aNotebookTabs = this.getNotebookTabs();
        for (BONotebookTab objBO : aNotebookTabs) {
            mNotebookTabList.put(objBO.getNotebookTabID(), objBO.printNotebookTab() + "\n");
        }
        return mNotebookTabList;
    }

    public String printNotebookTabHeader() {
        StringBuilder strNotebookTabHeader = new StringBuilder();
        strNotebookTabHeader.append(new BONotebookTab("").printNotebookTabHeader()).append("\n");
        return strNotebookTabHeader.toString();
    }

    public String printNotebookTabs() {
        StringBuilder strNotebookTabs = new StringBuilder();
        ArrayList<BONotebookTab> aNotebookTabs = this.getNotebookTabs();
        for (BONotebookTab objBO : aNotebookTabs) {
            strNotebookTabs.append(objBO.printNotebookTab()).append("\n");
        }
        return strNotebookTabs.toString();
    }

    public boolean validateNotebookTab(BONotebookTab objNotebookTab) {
        this.objNotebookTabValidate.clearValidations();
        return this.objNotebookTabValidate.validate(this.getNotebookTabs(), this.objSelectedNotebookTab, objNotebookTab);
    }

    public String getNotebookTabValidationMsg() {
        return this.objNotebookTabValidate.getValidationMsg();
    }

    public BONotebookNote addNotebookNote(String strName, String strDateCreated, String strTab, String strKeyWords, String strNoteID) {
        BONotebookNote objBO = new BONotebookNote(strNotebookNoteLineType);
        objBO.setNotebookNoteID(this.getNextNotebookNoteID());
        objBO.setName(strName);
        objBO.setDateCreated(strDateCreated);
        objBO.setTab(strTab);
        objBO.setKeyWords(strName);
        objBO.setNoteId(objBO.getNotebookNoteID());
        this.addBusinessObject(objBO);
        return objBO;
    }

    public ArrayList<BONotebookNote> getNotebookNotes() {
        ArrayList<BONotebookNote> aNotebookNotes = new ArrayList<BONotebookNote>();
        ArrayList<BusinessObject> aBusinessObjs = super.getBusinessObjectsOfLineType(strNotebookNoteLineType);
        for (BusinessObject objBusinessObj : aBusinessObjs) {
            BONotebookNote objBO = (BONotebookNote)objBusinessObj;
            aNotebookNotes.add(objBO);
        }
        Collections.sort(aNotebookNotes);
        return aNotebookNotes;
    }

    public int getNumOfNotebookNotes() {
        ArrayList<BONotebookNote> aNotebookNotes = this.getNotebookNotes();
        return aNotebookNotes.size();
    }

    public BONotebookNote getNotebookNoteByID(String strNotebookNoteID) {
        BONotebookNote objNotebookNote = null;
        ArrayList<BONotebookNote> aNotebookNotes = this.getNotebookNotes();
        for (BONotebookNote objBO : aNotebookNotes) {
            if (!objBO.getNotebookNoteID().equals(strNotebookNoteID)) continue;
            objNotebookNote = objBO;
            break;
        }
        return objNotebookNote;
    }

    public ArrayList<BONotebookNote> getNotebookNotesByTab(BONotebookTab objNotebookTab) {
        String strTabName = objNotebookTab.getTabName();
        ArrayList<BONotebookNote> aNotebookNotesByTab = new ArrayList<BONotebookNote>();
        ArrayList<BONotebookNote> aNotebookNotes = this.getNotebookNotes();
        for (BONotebookNote objBO : aNotebookNotes) {
            if (!objBO.getTab().equals(strTabName)) continue;
            aNotebookNotesByTab.add(objBO);
        }
        Collections.sort(aNotebookNotesByTab);
        return aNotebookNotesByTab;
    }

    public boolean deleteNotebookNoteByID(String strNotebookNoteID) {
        boolean bDeleted = false;
        BONotebookNote objNotebookNote = this.getNotebookNoteByID(strNotebookNoteID);
        if (objNotebookNote != null) {
            this.removeBusinessObject(objNotebookNote);
            bDeleted = true;
        }
        return bDeleted;
    }

    public void setSelectedNotebookNote(String strNotebookNoteID) {
        this.objSelectedNotebookNote = this.getNotebookNoteByID(strNotebookNoteID);
    }

    public BONotebookNote getSelectedNotebookNote() {
        return this.objSelectedNotebookNote;
    }

    private String getNextNotebookNoteID() {
        BusinessObjectSequence objSeq = this.getNotebookNoteSeq();
        if (objSeq != null) {
            return objSeq.getNextSeqValue();
        }
        return "0";
    }

    public Map<String, String> getNotebookNoteMap() {
        LinkedHashMap<String, String> mNotebookNoteList = new LinkedHashMap<String, String>();
        ArrayList<BONotebookNote> aNotebookNotes = this.getNotebookNotes();
        for (BONotebookNote objBO : aNotebookNotes) {
            mNotebookNoteList.put(objBO.getNotebookNoteID(), objBO.printNotebookNote() + "\n");
        }
        return mNotebookNoteList;
    }

    public String printNotebookNoteHeader() {
        StringBuilder strNotebookNoteHeader = new StringBuilder();
        strNotebookNoteHeader.append(new BONotebookNote("").printNotebookNoteHeader()).append("\n");
        return strNotebookNoteHeader.toString();
    }

    public String printNotebookNotes() {
        StringBuilder strNotebookNotes = new StringBuilder();
        ArrayList<BONotebookNote> aNotebookNotes = this.getNotebookNotes();
        for (BONotebookNote objBO : aNotebookNotes) {
            strNotebookNotes.append(objBO.printNotebookNote()).append("\n");
        }
        return strNotebookNotes.toString();
    }

    public boolean validateNotebookNote(BONotebookNote objNotebookNote) {
        this.objNotebookNoteValidate.clearValidations();
        return this.objNotebookNoteValidate.validate(this.getNotebookNotes(), this.objSelectedNotebookNote, objNotebookNote);
    }

    public String getNotebookNoteValidationMsg() {
        return this.objNotebookNoteValidate.getValidationMsg();
    }

    public boolean isUserNotebookOwner(BOUser objUser) {
        boolean bOwner = false;
        BONotebook objNotebook = this.getSelectedNotebook();
        if (objNotebook.getOwner().equals(objUser.getName())) {
            bOwner = true;
        }
        return bOwner;
    }

    public void clearSelections() {
        this.objSelectedNotebook = null;
        this.objSelectedNotebookTab = null;
        this.objSelectedNotebookNote = null;
    }

    public ArrayList<String> getLineTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(strSeqLineType);
        list.add(strNotebookLineType);
        list.add(strNotebookTabLineType);
        list.add(strNotebookNoteLineType);
        return list;
    }

    public void initSeqs() {
        this.addSequence(strNotebookSeqName, "0", "99999", "2", "0");
        this.addSequence(strNotebookTabSeqName, "0", "99999", "2", "0");
        this.addSequence(strNotebookNoteSeqName, "0", "99999", "2", "0");
    }

    @Override
    public ArrayList<BusinessObject> getBusinessObjectsOfLineType(String strLineType) {
        ArrayList<BusinessObject> aBusinessObjects = new ArrayList<BusinessObject>();
        switch (strLineType) {
            case "SEQC": {
                ArrayList<BusinessObjectSequence> aSequences = this.getSequences();
                for (BusinessObjectSequence objBO : aSequences) {
                    aBusinessObjects.add(objBO);
                }
                break;
            }
            case "NBBK": {
                ArrayList<BONotebook> aNotebooks = this.getNotebooks();
                for (BONotebook objBO : aNotebooks) {
                    aBusinessObjects.add(objBO);
                }
                break;
            }
            case "NBTB": {
                ArrayList<BONotebookTab> aNotebookTabs = this.getNotebookTabs();
                for (BONotebookTab objBO : aNotebookTabs) {
                    aBusinessObjects.add(objBO);
                }
                break;
            }
            case "NBNT": {
                ArrayList<BONotebookNote> aNotebookNotes = this.getNotebookNotes();
                for (BONotebookNote objBO : aNotebookNotes) {
                    aBusinessObjects.add(objBO);
                }
                break;
            }
        }
        return aBusinessObjects;
    }

    @Override
    public void initFile() {
        FOFileMgr objFileMgr = this.getFileMgr();
        FOFile objFile = this.getFile();
        objFileMgr.addFileLineToFile(new BusinessObjectSequence(strSeqLineType), objFile);
        objFileMgr.addFileLineToFile(new BONotebook(strNotebookLineType), objFile);
        objFileMgr.addFileLineToFile(new BONotebookTab(strNotebookTabLineType), objFile);
        objFileMgr.addFileLineToFile(new BONotebookNote(strNotebookNoteLineType), objFile);
    }

    @Override
    public void addBusinessObject(String strLineType, Map<String, String> mapAttrValues) {
        switch (strLineType) {
            case "SEQC": {
                BusinessObjectSequence objBO = new BusinessObjectSequence(strLineType);
                objBO.setMapOfAttrValues(mapAttrValues);
                this.addBusinessObject(objBO);
                break;
            }
            case "NBBK": {
                BONotebook objBO = new BONotebook(strLineType);
                objBO.setMapOfAttrValues(mapAttrValues);
                this.addBusinessObject(objBO);
                break;
            }
            case "NBTB": {
                BONotebookTab objBO = new BONotebookTab(strLineType);
                objBO.setMapOfAttrValues(mapAttrValues);
                this.addBusinessObject(objBO);
                break;
            }
            case "NBNT": {
                BONotebookNote objBO = new BONotebookNote(strLineType);
                objBO.setMapOfAttrValues(mapAttrValues);
                this.addBusinessObject(objBO);
                break;
            }
        }
    }

    @Override
    public void persistBusinessObjects() throws IOException {
        FOFileMgr objFileMgr = this.getFileMgr();
        FOFile objFile = this.getFile();
        objFileMgr.writeFile(this, objFile, true, false);
    }

    @Override
    public void parseBusinessObjects() throws IOException {
        FOFileMgr objFileMgr = this.getFileMgr();
        FOFile objFile = this.getFile();
        objFileMgr.readFile(this, objFile);
        this.initSeqs();
    }

    private boolean deleteNotebookTab(BONotebookTab objNotebookTab) {
        FOFileMgr objFileMgr = this.getFileMgr();
        String strFileDirectory = objFileMgr.getFilePath() + "tabs" + File.separator + objNotebookTab.getTabName();
        File objFile = new File(strFileDirectory);
        return objFile.delete();
    }
}

