/*
 * Decompiled with CFR 0.152.
 */
package mynotebook.bo.notebook;

import java.util.ArrayList;
import mynotebook.bo.notebook.BONotebook;

public class BONotebookValidate {
    private StringBuilder strValidationMsg = null;

    public String getValidationMsg() {
        return this.strValidationMsg.toString();
    }

    public void setValidationMsg(String strValidationMsg) {
        this.strValidationMsg = new StringBuilder().append("Validation Error: ").append(strValidationMsg).append("\n");
    }

    public void addValidationMsg(String strValidationMsg) {
        if (this.strValidationMsg == null) {
            this.setValidationMsg(strValidationMsg);
        } else {
            this.strValidationMsg.append("Validation Error: ").append(strValidationMsg).append("\n");
        }
    }

    public void clearValidations() {
        this.strValidationMsg = null;
    }

    public boolean validate(ArrayList<BONotebook> aNotebooks, BONotebook objSelectedNotebook, BONotebook objNotebook) {
        boolean bValid = true;
        if (this.checkMissingValues(objNotebook)) {
            this.checkDuplicate(aNotebooks, objNotebook);
        }
        if (this.strValidationMsg != null) {
            bValid = false;
        }
        return bValid;
    }

    private boolean checkMissingValues(BONotebook objNotebook) {
        boolean bValid = true;
        if (objNotebook.getNotebookName() == null || objNotebook.getNotebookName().isEmpty()) {
            this.addValidationMsg("NotebookName value is missing.");
            bValid = false;
        }
        if (objNotebook.getOwner() == null || objNotebook.getOwner().isEmpty()) {
            this.addValidationMsg("Owner value is missing.");
            bValid = false;
        }
        return bValid;
    }

    private boolean checkDuplicate(ArrayList<BONotebook> aNotebooks, BONotebook objNotebook) {
        boolean bValid = true;
        String strNotebookName = objNotebook.getNotebookName();
        String strOwner = objNotebook.getOwner();
        for (BONotebook objBO : aNotebooks) {
            if (!objBO.getNotebookName().equals(strNotebookName) || !objBO.getOwner().equals(strOwner)) continue;
            bValid = false;
            this.addValidationMsg("This business object already exists. ");
        }
        return bValid;
    }
}

