/*
 * Decompiled with CFR 0.152.
 */
package mynotebook.bo.tab;

import fof.bo.BusinessObject;
import java.util.Arrays;
import java.util.Map;
import mynotebook.bo.tab.BONotebookTabFormat;

public class BONotebookTab
extends BusinessObject
implements Comparable {
    private String strNotebookTabID;
    private static final String strNotebookTabIDName = "NBTab_ID";
    private static final int intNotebookTabIDLength = 10;
    private static final boolean bNotebookTabIDEncoded = false;
    private String strTabName;
    private static final String strTabNameName = "TabName";
    private static final int intTabNameLength = 20;
    private static final boolean bTabNameEncoded = false;
    private final BONotebookTabFormat objNotebookTabFormat = new BONotebookTabFormat();

    public BONotebookTab() {
    }

    public BONotebookTab(String strLineType) {
        this.setLineType(strLineType);
    }

    public BONotebookTab(String strLineType, String strNotebookTabID, String strTabName) {
        this.setLineType(strLineType);
        this.setNotebookTabID(strNotebookTabID);
        this.setTabName(strTabName);
    }

    public String getNotebookTabID() {
        return this.strNotebookTabID;
    }

    public void setNotebookTabID(String strNotebookTabID) {
        this.strNotebookTabID = this.objNotebookTabFormat.formatNotebookTabID(strNotebookTabID, 10);
    }

    public String getTabName() {
        return this.strTabName;
    }

    public void setTabName(String strTabName) {
        this.strTabName = this.objNotebookTabFormat.formatTabName(strTabName, 20);
    }

    public String printNotebookTabHeader() {
        StringBuilder strLine = new StringBuilder();
        strLine.append(this.getFieldString(strTabNameName, 20));
        strLine.append(" ");
        return strLine.toString();
    }

    public String printNotebookTab() {
        StringBuilder strLine = new StringBuilder();
        strLine.append(this.getFieldString(this.getTabName(), 20));
        strLine.append(" ");
        return strLine.toString();
    }

    protected String getFieldString(String strValue, int intLength) {
        StringBuilder strFieldString = new StringBuilder("");
        char chFillCh = ' ';
        if (intLength > 0) {
            char[] chArray = new char[intLength];
            Arrays.fill(chArray, chFillCh);
            strFieldString = new StringBuilder(new String(chArray));
            strFieldString.replace(0, strValue.length(), strValue);
        }
        return strFieldString.toString();
    }

    @Override
    public Map<String, Map<String, Object>> getMapOfAttrValues() {
        this.initAttrMap();
        this.addAttrToMap(strNotebookTabIDName, this.getNotebookTabID(), 10, this.getNextLineFieldIdx(), false);
        this.addAttrToMap(strTabNameName, this.getTabName(), 20, this.getNextLineFieldIdx(), false);
        return this.getAttrMap();
    }

    @Override
    public void setMapOfAttrValues(Map<String, String> mapAttrValues) {
        for (Map.Entry<String, String> entry : mapAttrValues.entrySet()) {
            String mapKey = entry.getKey();
            String mapValue = entry.getValue();
            switch (mapKey) {
                case "NBTab_ID": {
                    this.setNotebookTabID(mapValue);
                    break;
                }
                case "TabName": {
                    this.setTabName(mapValue);
                }
            }
        }
    }

    public int compareTo(Object objNotebookTab) {
        BONotebookTab objComp = (BONotebookTab)objNotebookTab;
        return this.strTabName.compareTo(objComp.getTabName());
    }
}

