/*
 * Decompiled with CFR 0.152.
 */
package mynotebook.bo.user;

import fof.bo.BusinessObject;
import java.util.Arrays;
import java.util.Map;
import mynotebook.bo.user.BOUserFormat;

public class BOUser
extends BusinessObject
implements Comparable {
    private String strUserID;
    private static final String strUserIDName = "User_ID";
    private static final int intUserIDLength = 10;
    private static final boolean bUserIDEncoded = false;
    private String strName;
    private static final String strNameName = "Name";
    private static final int intNameLength = 20;
    private static final boolean bNameEncoded = true;
    private String strPassword;
    private static final String strPasswordName = "Password";
    private static final int intPasswordLength = 20;
    private static final boolean bPasswordEncoded = true;
    private String strAdmin;
    private static final String strAdminName = "Admin";
    private static final int intAdminLength = 5;
    private static final boolean bAdminEncoded = true;
    private final BOUserFormat objUserFormat = new BOUserFormat();

    public BOUser() {
    }

    public BOUser(String strLineType) {
        this.setLineType(strLineType);
    }

    public BOUser(String strLineType, String strUserID, String strName, String strPassword, String strAdmin) {
        this.setLineType(strLineType);
        this.setUserID(strUserID);
        this.setName(strName);
        this.setPassword(strPassword);
        this.setAdmin(strAdmin);
    }

    public String getUserID() {
        return this.strUserID;
    }

    public void setUserID(String strUserID) {
        this.strUserID = this.objUserFormat.formatUserID(strUserID, 10);
    }

    public String getName() {
        return this.strName;
    }

    public void setName(String strName) {
        this.strName = this.objUserFormat.formatName(strName, 20);
    }

    public String getPassword() {
        return this.strPassword;
    }

    public void setPassword(String strPassword) {
        this.strPassword = this.objUserFormat.formatPassword(strPassword, 20);
    }

    public String getAdmin() {
        return this.strAdmin;
    }

    public void setAdmin(String strAdmin) {
        this.strAdmin = this.objUserFormat.formatAdmin(strAdmin, 5);
    }

    public boolean isAdmin() {
        return this.strAdmin.equals("true");
    }

    public String printUserHeader() {
        StringBuilder strLine = new StringBuilder();
        strLine.append(this.getFieldString(strNameName, 20));
        strLine.append(" ");
        strLine.append(this.getFieldString(strPasswordName, 20));
        strLine.append(" ");
        strLine.append(this.getFieldString(strAdminName, 5));
        strLine.append(" ");
        return strLine.toString();
    }

    public String printUser() {
        StringBuilder strLine = new StringBuilder();
        strLine.append(this.getFieldString(this.getName(), 20));
        strLine.append(" ");
        strLine.append(this.getFieldString(this.getPassword(), 20));
        strLine.append(" ");
        strLine.append(this.getFieldString(this.getAdmin(), 5));
        strLine.append(" ");
        return strLine.toString();
    }

    protected String getFieldString(String strValue, int intLength) {
        StringBuilder strFieldString = new StringBuilder("");
        char chFillCh = ' ';
        if (intLength > 0) {
            char[] chArray = new char[intLength];
            Arrays.fill(chArray, chFillCh);
            strFieldString = new StringBuilder(new String(chArray));
            strFieldString.replace(0, strValue.length(), strValue);
        }
        return strFieldString.toString();
    }

    @Override
    public Map<String, Map<String, Object>> getMapOfAttrValues() {
        this.initAttrMap();
        this.addAttrToMap(strUserIDName, this.getUserID(), 10, this.getNextLineFieldIdx(), false);
        this.addAttrToMap(strNameName, this.getName(), 20, this.getNextLineFieldIdx(), true);
        this.addAttrToMap(strPasswordName, this.getPassword(), 20, this.getNextLineFieldIdx(), true);
        this.addAttrToMap(strAdminName, this.getAdmin(), 5, this.getNextLineFieldIdx(), true);
        return this.getAttrMap();
    }

    @Override
    public void setMapOfAttrValues(Map<String, String> mapAttrValues) {
        for (Map.Entry<String, String> entry : mapAttrValues.entrySet()) {
            String mapKey = entry.getKey();
            String mapValue = entry.getValue();
            switch (mapKey) {
                case "User_ID": {
                    this.setUserID(mapValue);
                    break;
                }
                case "Name": {
                    this.setName(mapValue);
                    break;
                }
                case "Password": {
                    this.setPassword(mapValue);
                    break;
                }
                case "Admin": {
                    this.setAdmin(mapValue);
                }
            }
        }
    }

    public int compareTo(Object objUser) {
        BOUser objComp = (BOUser)objUser;
        return this.strName.compareTo(objComp.getName());
    }
}

