/*
 * Decompiled with CFR 0.152.
 */
package mynotebook.bo.user;

import fof.bo.BusinessObject;
import fof.bo.BusinessObjectMgr;
import fof.bo.BusinessObjectSequence;
import fof.file.FOFile;
import fof.file.FOFileMgr;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import mynotebook.bo.user.BOUser;
import mynotebook.bo.user.BOUserValidate;

public class BOUserMgr
extends BusinessObjectMgr {
    private BusinessObjectSequence objUserSeq;
    private BOUser objSelectedUser;
    private static final String strUserSeqName = "User_SEQ";
    private static final String strUserLineType = "MNUS";
    private static final String strSeqLineType = "SEQC";
    private final BOUserValidate objUserValidate = new BOUserValidate();
    private boolean bAdminDisabled = false;

    public BOUserMgr() {
    }

    public BOUserMgr(FOFileMgr objFileMgr, FOFile objFile) {
        super(objFileMgr, objFile);
    }

    public void addSequence(String strSeqName, String strSeqStart, String strSeqMax, String strSeqIncr, String strSeqValue) {
        BusinessObjectSequence objBO = this.getSeq(strSeqName);
        if (objBO == null) {
            objBO = new BusinessObjectSequence(strSeqLineType);
            objBO.setSeqName(strSeqName);
            objBO.setSeqStart(strSeqStart);
            objBO.setSeqMax(strSeqMax);
            objBO.setSeqIncr(strSeqIncr);
            objBO.setSeqValue(strSeqValue);
            this.addBusinessObject(objBO);
        }
    }

    public ArrayList<BusinessObjectSequence> getSequences() {
        ArrayList<BusinessObjectSequence> aSequences = new ArrayList<BusinessObjectSequence>();
        ArrayList<BusinessObject> aBusinessObjs = super.getBusinessObjectsOfLineType(strSeqLineType);
        for (BusinessObject objBusinessObj : aBusinessObjs) {
            BusinessObjectSequence objBO = (BusinessObjectSequence)objBusinessObj;
            aSequences.add(objBO);
        }
        return aSequences;
    }

    public BusinessObjectSequence getSeq(String strSeqName) {
        BusinessObjectSequence objSeq = null;
        ArrayList<BusinessObjectSequence> aSequences = this.getSequences();
        for (BusinessObjectSequence objBO : aSequences) {
            if (!objBO.getSeqName().equals(strSeqName)) continue;
            objSeq = objBO;
            break;
        }
        return objSeq;
    }

    public BusinessObjectSequence getUserSeq() {
        if (this.objUserSeq == null) {
            this.objUserSeq = this.getSeq(strUserSeqName);
        }
        return this.objUserSeq;
    }

    public void addUser(String strName, String strPassword, String strAdmin) {
        BOUser objBO = new BOUser(strUserLineType);
        objBO.setUserID(this.getNextUserID());
        objBO.setName(strName);
        objBO.setPassword(strPassword);
        objBO.setAdmin(strAdmin);
        this.addBusinessObject(objBO);
    }

    public ArrayList<BOUser> getUsers() {
        ArrayList<BOUser> aUsers = new ArrayList<BOUser>();
        ArrayList<BusinessObject> aBusinessObjs = super.getBusinessObjectsOfLineType(strUserLineType);
        for (BusinessObject objBusinessObj : aBusinessObjs) {
            BOUser objBO = (BOUser)objBusinessObj;
            aUsers.add(objBO);
        }
        Collections.sort(aUsers);
        return aUsers;
    }

    public int getNumOfUsers() {
        ArrayList<BOUser> aUsers = this.getUsers();
        return aUsers.size();
    }

    public BOUser getUserByID(String strUserID) {
        BOUser objUser = null;
        ArrayList<BOUser> aUsers = this.getUsers();
        for (BOUser objBO : aUsers) {
            if (!objBO.getUserID().equals(strUserID)) continue;
            objUser = objBO;
            break;
        }
        return objUser;
    }

    public boolean deleteUserByID(String strUserID) {
        boolean bDeleted = false;
        BOUser objUser = this.getUserByID(strUserID);
        if (objUser != null) {
            this.removeBusinessObject(objUser);
            bDeleted = true;
        }
        return bDeleted;
    }

    public void setSelectedUser(String strUserID) {
        this.objSelectedUser = this.getUserByID(strUserID);
    }

    public BOUser getSelectedUser() {
        return this.objSelectedUser;
    }

    private String getNextUserID() {
        BusinessObjectSequence objSeq = this.getUserSeq();
        if (objSeq != null) {
            return objSeq.getNextSeqValue();
        }
        return "0";
    }

    public Map<String, String> getUserMap() {
        LinkedHashMap<String, String> mUserList = new LinkedHashMap<String, String>();
        ArrayList<BOUser> aUsers = this.getUsers();
        for (BOUser objBO : aUsers) {
            mUserList.put(objBO.getUserID(), objBO.printUser() + "\n");
        }
        return mUserList;
    }

    public String printUserHeader() {
        StringBuilder strUserHeader = new StringBuilder();
        strUserHeader.append(new BOUser("").printUserHeader()).append("\n");
        return strUserHeader.toString();
    }

    public String printUsers() {
        StringBuilder strUsers = new StringBuilder();
        ArrayList<BOUser> aUsers = this.getUsers();
        for (BOUser objBO : aUsers) {
            strUsers.append(objBO.printUser()).append("\n");
        }
        return strUsers.toString();
    }

    public boolean validateUser(BOUser objUser) {
        this.objUserValidate.clearValidations();
        return this.objUserValidate.validate(this.getUsers(), this.objSelectedUser, objUser);
    }

    public String getUserValidationMsg() {
        return this.objUserValidate.getValidationMsg();
    }

    public void createAdminUser() {
        BOUser objAdminUser = this.getUserByID("0000000002");
        if (objAdminUser == null) {
            this.addUser("admin", "password", "true");
        }
    }

    public void disableAdminUser() {
        this.bAdminDisabled = true;
    }

    public void enableAdminUser() {
        this.bAdminDisabled = false;
    }

    public boolean isAdminDisabled() {
        return this.bAdminDisabled;
    }

    public boolean isAnyUserAdmin() {
        ArrayList<BOUser> aUsers = this.getUsers();
        for (BOUser objBO : aUsers) {
            if (objBO.getName().equals("admin") || !objBO.getAdmin().equals("true")) continue;
            return true;
        }
        return false;
    }

    public BOUser isValidUser(BOUser objUser) {
        BOUser objValidUser = null;
        ArrayList<BOUser> aUsers = this.getUsers();
        for (BOUser objBO : aUsers) {
            if (!objBO.getName().equals(objUser.getName()) || !objBO.getPassword().equals(objUser.getPassword()) || this.bAdminDisabled && objBO.getName().equals("admin")) continue;
            objValidUser = objBO;
            break;
        }
        return objValidUser;
    }

    public boolean isExistingUser(BOUser objUser) {
        ArrayList<BOUser> aUsers = this.getUsers();
        for (BOUser objBO : aUsers) {
            if (!objBO.getName().equals(objUser.getName())) continue;
            return true;
        }
        return false;
    }

    public void deleteUserByName(BOUser objUser) {
        ArrayList<BOUser> aUsers = this.getUsers();
        for (BOUser objBO : aUsers) {
            if (!objBO.getName().equals(objUser.getName())) continue;
            this.deleteUserByID(objBO.getUserID());
            return;
        }
    }

    public void updateUserByName(BOUser objUser) {
        ArrayList<BOUser> aUsers = this.getUsers();
        for (BOUser objBO : aUsers) {
            if (!objBO.getName().equals(objUser.getName())) continue;
            objBO.setPassword(objUser.getPassword());
            objBO.setAdmin(objUser.getAdmin());
            return;
        }
    }

    public void clearSelections() {
        this.objSelectedUser = null;
    }

    public ArrayList<String> getLineTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(strSeqLineType);
        list.add(strUserLineType);
        return list;
    }

    public void initSeqs() {
        this.addSequence(strUserSeqName, "0", "99999", "2", "0");
    }

    @Override
    public ArrayList<BusinessObject> getBusinessObjectsOfLineType(String strLineType) {
        ArrayList<BusinessObject> aBusinessObjects = new ArrayList<BusinessObject>();
        switch (strLineType) {
            case "SEQC": {
                ArrayList<BusinessObjectSequence> aSequences = this.getSequences();
                for (BusinessObjectSequence objBO : aSequences) {
                    aBusinessObjects.add(objBO);
                }
                break;
            }
            case "MNUS": {
                ArrayList<BOUser> aUsers = this.getUsers();
                for (BOUser objBO : aUsers) {
                    aBusinessObjects.add(objBO);
                }
                break;
            }
        }
        return aBusinessObjects;
    }

    @Override
    public void initFile() {
        FOFileMgr objFileMgr = this.getFileMgr();
        FOFile objFile = this.getFile();
        objFileMgr.addFileLineToFile(new BusinessObjectSequence(strSeqLineType), objFile);
        objFileMgr.addFileLineToFile(new BOUser(strUserLineType), objFile);
    }

    @Override
    public void addBusinessObject(String strLineType, Map<String, String> mapAttrValues) {
        switch (strLineType) {
            case "SEQC": {
                BusinessObjectSequence objBO = new BusinessObjectSequence(strLineType);
                objBO.setMapOfAttrValues(mapAttrValues);
                this.addBusinessObject(objBO);
                break;
            }
            case "MNUS": {
                BOUser objBO = new BOUser(strLineType);
                objBO.setMapOfAttrValues(mapAttrValues);
                this.addBusinessObject(objBO);
                break;
            }
        }
    }

    @Override
    public void persistBusinessObjects() throws IOException {
        FOFileMgr objFileMgr = this.getFileMgr();
        FOFile objFile = this.getFile();
        objFileMgr.writeFile(this, objFile, true, false);
    }

    @Override
    public void parseBusinessObjects() throws IOException {
        FOFileMgr objFileMgr = this.getFileMgr();
        FOFile objFile = this.getFile();
        objFileMgr.readFile(this, objFile);
        this.initSeqs();
    }
}

