/*
 * Decompiled with CFR 0.152.
 */
package mynotebook.bo.user;

import java.util.ArrayList;
import mynotebook.bo.user.BOUser;

public class BOUserValidate {
    private StringBuilder strValidationMsg = null;

    public String getValidationMsg() {
        return this.strValidationMsg.toString();
    }

    public void setValidationMsg(String strValidationMsg) {
        this.strValidationMsg = new StringBuilder().append("Validation Error: ").append(strValidationMsg).append("\n");
    }

    public void addValidationMsg(String strValidationMsg) {
        if (this.strValidationMsg == null) {
            this.setValidationMsg(strValidationMsg);
        } else {
            this.strValidationMsg.append("Validation Error: ").append(strValidationMsg).append("\n");
        }
    }

    public void clearValidations() {
        this.strValidationMsg = null;
    }

    public boolean validate(ArrayList<BOUser> aUsers, BOUser objSelectedUser, BOUser objUser) {
        boolean bValid = true;
        if (this.checkMissingValues(objUser)) {
            this.checkDuplicate(aUsers, objUser);
        }
        if (this.strValidationMsg != null) {
            bValid = false;
        }
        return bValid;
    }

    private boolean checkMissingValues(BOUser objUser) {
        boolean bValid = true;
        if (objUser.getName() == null || objUser.getName().isEmpty()) {
            this.addValidationMsg("Name value is missing.");
            bValid = false;
        }
        if (objUser.getPassword() == null || objUser.getPassword().isEmpty()) {
            this.addValidationMsg("Password value is missing.");
            bValid = false;
        }
        if (objUser.getAdmin() == null || objUser.getAdmin().isEmpty()) {
            this.addValidationMsg("Admin value is missing.");
            bValid = false;
        }
        return bValid;
    }

    private boolean checkDuplicate(ArrayList<BOUser> aUsers, BOUser objUser) {
        boolean bValid = true;
        String strName = objUser.getName();
        String strPassword = objUser.getPassword();
        String strAdmin = objUser.getAdmin();
        for (BOUser objBO : aUsers) {
            if (!objBO.getName().equals(strName) || !objBO.getPassword().equals(strPassword) || !objBO.getAdmin().equals(strAdmin)) continue;
            bValid = false;
            this.addValidationMsg("This business object already exists. ");
        }
        return bValid;
    }
}

