/*
 * Decompiled with CFR 0.152.
 */
package mynotebook.controller;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import mynotebook.MyNotebook;
import mynotebook.model.AbstractModel;
import mynotebook.view.AbstractViewPanel;

public abstract class AbstractController
implements PropertyChangeListener {
    private ArrayList<AbstractViewPanel> registeredViews = new ArrayList();
    private ArrayList<AbstractModel> registeredModels = new ArrayList();

    public void addModel(AbstractModel model) {
        this.registeredModels.add(model);
        model.addPropertyChangeListener(this);
    }

    public void removeModel(AbstractModel model) {
        this.registeredModels.remove(model);
        model.removePropertyChangeListener(this);
    }

    public void addView(AbstractViewPanel view) {
        this.registeredViews.add(view);
    }

    public void removeView(AbstractViewPanel view) {
        this.registeredViews.remove(view);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        for (AbstractViewPanel view : this.registeredViews) {
            view.modelPropertyChange(evt);
        }
    }

    protected void setModelProperty(String propertyName, Object newValue) {
        for (AbstractModel model : this.registeredModels) {
            try {
                Method method = model.getClass().getMethod(propertyName, newValue.getClass());
                method.invoke((Object)model, newValue);
            }
            catch (Exception ex) {
                MyNotebook.consoleOutput("MyNotebook : AbstractController.setModelProperty() : method invoke failed : " + propertyName);
                MyNotebook.consoleOutput(ex.toString());
                MyNotebook.consoleOutput(ex.getMessage());
            }
        }
    }
}

