/*
 * Decompiled with CFR 0.152.
 */
package mynotebook.model;

import fof.file.FOFile;
import fof.file.FOFileMgr;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import mynotebook.MyNotebook;
import mynotebook.bo.note.BONote;
import mynotebook.bo.note.BONoteMgr;
import mynotebook.bo.note.BONotebookNote;
import mynotebook.bo.notebook.BONotebook;
import mynotebook.bo.notebook.BONotebookEncoder;
import mynotebook.bo.notebook.BONotebookMgr;
import mynotebook.bo.tab.BONotebookTab;
import mynotebook.bo.user.BOUser;
import mynotebook.bo.user.BOUserMgr;
import mynotebook.model.AbstractModel;
import mynotebook.model.ModelContext;

public class NotebookModel
extends AbstractModel {
    public ModelContext objContext = new ModelContext();
    private FOFileMgr objFileMgr;
    private BONotebookMgr objNotebookMgr;
    private BOUserMgr objUserMgr;
    private BONoteMgr objNoteMgr;

    public NotebookModel(BOUserMgr objUserMgr) {
        this.objUserMgr = objUserMgr;
    }

    public void initDefault() {
    }

    public void CreateNotebook(String strNotebookName) {
        String message = "NOMSG";
        String strDir = strNotebookName.substring(0, strNotebookName.lastIndexOf(File.separator));
        String strFilename = strNotebookName.substring(strNotebookName.lastIndexOf(File.separator) + 1);
        this.objFileMgr = new FOFileMgr(strNotebookName);
        this.objFileMgr.setEncoder(new BONotebookEncoder());
        message = this.initNotebookBO(strFilename + ".mnb");
        if (!message.equals("NOMSG")) {
            this.setContext(message, strNotebookName, null, null);
            this.firePropertyChange("CreateNotebook", this.objContext);
            return;
        }
        this.objNotebookMgr.addNotebook(strFilename, this.objUserMgr.getSelectedUser().getName());
        this.objNotebookMgr.setSelectedNotebook("0000000002");
        message = this.initNoteBO();
        if (!message.equals("NOMSG")) {
            this.setContext(message, strNotebookName, null, null);
            this.firePropertyChange("CreateNotebook", this.objContext);
            return;
        }
        this.setContext(message, strNotebookName, this.objNotebookMgr.getSelectedNotebook(), null);
        this.firePropertyChange("CreateNotebook", this.objContext);
    }

    public void ReadNotebook(String strNotebookName) {
        String message = "NOMSG";
        String strDir = strNotebookName.substring(0, strNotebookName.lastIndexOf(File.separator));
        String strFilename = strNotebookName.substring(strNotebookName.lastIndexOf(File.separator) + 1);
        this.objFileMgr = new FOFileMgr(strDir);
        this.objFileMgr.setEncoder(new BONotebookEncoder());
        message = this.initNotebookBO(strFilename);
        if (!message.equals("NOMSG")) {
            this.setContext(message, strNotebookName, null, null);
            this.firePropertyChange("ReadNotebook", this.objContext);
            return;
        }
        this.objNotebookMgr.setSelectedNotebook("0000000002");
        if (!this.objNotebookMgr.isUserNotebookOwner(this.objUserMgr.getSelectedUser())) {
            message = "This notebook cannot be opened by you.";
            MyNotebook.consoleOutput("MyNotebook : NotebookModel.initNotebookBO() : user verification failed.");
            this.objNotebookMgr.clearBusinessObjects();
            this.objNotebookMgr = null;
            this.setContext(message, strNotebookName, null, null);
            this.firePropertyChange("ReadNotebook", this.objContext);
            return;
        }
        message = this.initNoteBO();
        if (!message.equals("NOMSG")) {
            this.setContext(message, strNotebookName, null, null);
            this.firePropertyChange("ReadNotebook", this.objContext);
            return;
        }
        ArrayList<BONotebookTab> aTabs = this.objNotebookMgr.getNotebookTabs();
        this.setContext(message, strNotebookName, this.objNotebookMgr.getSelectedNotebook(), aTabs);
        this.firePropertyChange("ReadNotebook", this.objContext);
    }

    public void UpdateNotebook(BONotebook objNotebook) {
        String message = "NOMSG";
        message = this.saveNotebook();
        this.setContext(message, null, null, null);
        this.firePropertyChange("UpdateNotebook", this.objContext);
    }

    public void DeleteNotebook(BONotebook objNotebook) {
        String message = "NOMSG";
        this.setContext(message, null, null, null);
        this.firePropertyChange("DeleteNotebook", this.objContext);
    }

    public void CloseNotebook(BONotebook objNotebook) {
        String message = "NOMSG";
        message = this.saveNotebook();
        this.setContext(message, null, null, null);
        this.firePropertyChange("CloseNotebook", this.objContext);
    }

    public void CreateTab(BONotebookTab objNotebookTab) {
        String message = "NOMSG";
        this.objNotebookMgr.addNotebookTab(objNotebookTab.getTabName(), true);
        ArrayList<BONotebookTab> aTabs = this.objNotebookMgr.getNotebookTabs();
        this.setContext(message, this.objNotebookMgr.getSelectedNotebookTab(), aTabs, null);
        this.firePropertyChange("CreateTab", this.objContext);
    }

    public void ReadTab(BONotebookTab objNotebookTab) {
        String message = "NOMSG";
        this.objNotebookMgr.setSelectedNotebookTab(objNotebookTab.getNotebookTabID());
        ArrayList<BONotebookNote> aNotebookNotes = this.objNotebookMgr.getNotebookNotesByTab(objNotebookTab);
        this.setContext(message, this.objNotebookMgr.getSelectedNotebookTab(), aNotebookNotes, null);
        this.firePropertyChange("ReadTab", this.objContext);
    }

    public void UpdateTab(BONotebookTab objTab) {
        String message = "NOMSG";
        this.setContext(message, this.objNotebookMgr.getSelectedNotebookTab(), null, null);
        this.firePropertyChange("UpdateTab", this.objContext);
    }

    public void DeleteTab(BONotebookTab objTab) {
        String message = "NOMSG";
        ArrayList<BONotebookNote> aNotebookNotes = this.objNotebookMgr.getNotebookNotesByTab(objTab);
        for (BONotebookNote objNotebookNote : aNotebookNotes) {
            if (!this.objNoteMgr.deleteNoteByNotebookNote(objNotebookNote)) {
                message = "A note in the tab could not be deleted.";
                this.objContext.addProperty("MODEL_CTX_MSG", message);
                this.firePropertyChange("DeleteTab", this.objContext);
                return;
            }
            this.objNotebookMgr.deleteNotebookNoteByID(objNotebookNote.getNotebookNoteID());
        }
        this.objNotebookMgr.deleteNotebookTabByID(objTab.getNotebookTabID(), true);
        ArrayList<BONotebookTab> aTabs = this.objNotebookMgr.getNotebookTabs();
        this.setContext(message, objTab, aTabs, null);
        this.firePropertyChange("DeleteTab", this.objContext);
    }

    public void CloseTab(BONotebookTab objTab) {
        String message = "NOMSG";
        this.setContext(message, objTab, null, null);
        this.firePropertyChange("CloseTab", this.objContext);
    }

    public void CancelTab(Object obj) {
        String message = "NOMSG";
        this.setContext(message, null, null, null);
        this.firePropertyChange("CancelTab", this.objContext);
    }

    public void CreateNote(BONote objNote) {
        String message = "NOMSG";
        BONotebookNote objAddedNotebookNote = this.objNotebookMgr.addNotebookNote(objNote.getName(), objNote.getDateCreated(), objNote.getTab(), objNote.getKeyWords(), objNote.getNoteID());
        BONote objAddedNote = this.objNoteMgr.addNote(objNote.getName(), objNote.getAuthor(), objNote.getTab(), objNote.getKeyWords(), objNote.getAttachments(), objNote.getDateCreated(), objNote.getDateModified(), objNote.getEntry(), objAddedNotebookNote.getNotebookNoteID());
        objAddedNote.setEncoded(objNote.isEncoded());
        if (!this.objNoteMgr.saveNoteByID(objAddedNote.getNoteID())) {
            this.objNoteMgr.deleteNoteByID(objAddedNote.getNoteID(), false);
            this.objNotebookMgr.deleteNotebookNoteByID(objAddedNotebookNote.getNotebookNoteID());
            message = "Note could not be saved to the file system.";
            this.setContext(message, null, null, null);
            this.firePropertyChange("CreateNote", this.objContext);
            return;
        }
        ArrayList<BONotebookNote> aNotebookNotes = this.objNotebookMgr.getNotebookNotesByTab(this.objNotebookMgr.getSelectedNotebookTab());
        this.setContext(message, this.objNotebookMgr.getSelectedNotebookTab(), aNotebookNotes, null);
        this.firePropertyChange("CreateNote", this.objContext);
    }

    public void ReadNote(BONotebookNote objNotebookNote) {
        String message = "NOMSG";
        BONote objNote = this.objNoteMgr.getNoteByNotebookNote(objNotebookNote);
        this.objNoteMgr.setSelectedNote(objNote.getNoteID());
        this.setContext(message, this.objNoteMgr.getSelectedNote(), null, null);
        this.firePropertyChange("ReadNote", this.objContext);
    }

    public void UpdateNote(BONote objNote) {
        String message = "NOMSG";
        if (!this.objNoteMgr.saveNoteByID(objNote.getNoteID())) {
            message = "Note could not be saved to the file system.";
            this.objContext.addProperty("MODEL_CTX_MSG", message);
            this.firePropertyChange("UpdateNote", this.objContext);
            return;
        }
        BONotebookNote objNotebookNote = this.objNotebookMgr.getNotebookNoteByID(objNote.getNoteID());
        if (!objNotebookNote.getName().equals(objNote.getName())) {
            this.objNoteMgr.deleteNoteByNotebookNote(objNotebookNote);
            objNotebookNote.setName(objNote.getName());
        }
        this.objNoteMgr.setSelectedNote(objNote.getNoteID());
        this.setContext(message, this.objNoteMgr.getSelectedNote(), null, null);
        this.firePropertyChange("UpdateNote", this.objContext);
    }

    public void DeleteNote(BONotebookNote objNotebookNote) {
        String message = "NOMSG";
        if (!this.objNoteMgr.deleteNoteByID(objNotebookNote.getNoteId(), true)) {
            message = "Note could not be deleted from the file system.";
            this.objContext.addProperty("MODEL_CTX_MSG", message);
            this.firePropertyChange("DeleteNote", this.objContext);
            return;
        }
        this.objNotebookMgr.deleteNotebookNoteByID(objNotebookNote.getNotebookNoteID());
        ArrayList<BONotebookNote> aNotebookNotes = this.objNotebookMgr.getNotebookNotesByTab(this.objNotebookMgr.getSelectedNotebookTab());
        this.setContext(message, this.objNotebookMgr.getSelectedNotebookTab(), aNotebookNotes, objNotebookNote);
        this.firePropertyChange("DeleteNote", this.objContext);
    }

    public void CloseNote(BONote objNote) {
        String message = "NOMSG";
        this.setContext(message, objNote, null, null);
        this.firePropertyChange("CloseNote", this.objContext);
    }

    public void CancelNote(BONote objNote) {
        String message = "NOMSG";
        this.setContext(message, objNote, null, null);
        this.firePropertyChange("CancelNote", this.objContext);
    }

    public void CreateUser(BOUser objUser) {
        String message = "NOMSG";
        if (!this.objUserMgr.isExistingUser(objUser)) {
            this.objUserMgr.addUser(objUser.getName(), objUser.getPassword(), objUser.getAdmin());
        } else {
            message = "That user already exists.";
        }
        this.setContext(message, objUser, null, null);
        this.firePropertyChange("CreateUser", this.objContext);
    }

    public void ReadUser(BOUser objUser) {
        String message = "NOMSG";
        BOUser objValidUser = this.objUserMgr.isValidUser(objUser);
        if (objValidUser != null) {
            this.objUserMgr.setSelectedUser(objValidUser.getUserID());
        } else {
            message = "That user name or password is invalid.";
        }
        this.setContext(message, this.objUserMgr.getSelectedUser(), null, null);
        this.firePropertyChange("ReadUser", this.objContext);
    }

    public void UpdateUser(BOUser objUser) {
        String message = "NOMSG";
        if (this.objUserMgr.isExistingUser(objUser)) {
            this.objUserMgr.updateUserByName(objUser);
        } else {
            message = "That user does not exists.";
        }
        this.setContext(message, objUser, null, null);
        this.firePropertyChange("UpdateUser", this.objContext);
    }

    public void DeleteUser(BOUser objUser) {
        String message = "NOMSG";
        if (this.objUserMgr.isExistingUser(objUser)) {
            this.objUserMgr.deleteUserByName(objUser);
        } else {
            message = "That user does not exist.";
        }
        this.setContext(message, objUser, null, null);
        this.firePropertyChange("DeleteUser", this.objContext);
    }

    public void CloseUser(BOUser objUser) {
        String message = "NOMSG";
        this.setContext(message, objUser, null, null);
        this.firePropertyChange("CloseUser", this.objContext);
    }

    public void CancelUser(Object obj) {
        String message = "NOMSG";
        this.setContext(message, null, null, null);
        this.firePropertyChange("CancelUser", this.objContext);
    }

    private void setContext(String strMessage, Object objA, Object objB, Object objC) {
        this.objContext.clearProperties();
        this.objContext.addProperty("MODEL_CTX_MSG", strMessage);
        if (objA != null) {
            this.objContext.addProperty("MODEL_CTX_A", objA);
        }
        if (objB != null) {
            this.objContext.addProperty("MODEL_CTX_B", objB);
        }
        if (objC != null) {
            this.objContext.addProperty("MODEL_CTX_C", objC);
        }
    }

    private String initNotebookBO(String strFilename) {
        String message = "NOMSG";
        if (this.objFileMgr == null || this.objUserMgr == null) {
            message = "The notebook cannot be opened.";
            MyNotebook.consoleOutput("MyNotebook : NotebookModel.initNotebookBO() : objFileMgr and/or objUserMgr is null.");
            return message;
        }
        FOFile objNotebookFile = new FOFile();
        objNotebookFile.setFileName(strFilename);
        objNotebookFile.setFileDirectory("");
        this.objNotebookMgr = new BONotebookMgr(this.objFileMgr, objNotebookFile);
        this.objNotebookMgr.initFile();
        if (!this.objFileMgr.verifyFilePath(this.objNotebookMgr.getFile())) {
            message = "The notebook cannot be opened. System file path issue.";
            MyNotebook.consoleOutput("MyNotebook : NotebookModel.initNotebookBO() : verifyFilePath failed.");
            this.objNotebookMgr = null;
        }
        if (this.objNotebookMgr != null) {
            if (this.objFileMgr.verifyFileExists(this.objNotebookMgr.getFile())) {
                try {
                    this.objNotebookMgr.parseBusinessObjects();
                }
                catch (IOException ex) {
                    message = "The notebook cannot be opened. File parsing issue.";
                    MyNotebook.consoleOutput("MyNotebook : NotebookModel.initNotebookBO() : parseBusinessObjects failed.");
                    MyNotebook.consoleOutput(ex.toString());
                    this.objNotebookMgr = null;
                }
            } else {
                MyNotebook.consoleOutput("MyNotebook : NotebookModel.initNotebookBO() : Missing Notebook file. Creating Notebook.");
                this.objNotebookMgr.initSeqs();
            }
        }
        return message;
    }

    private String initNoteBO() {
        String message = "NOMSG";
        if (this.objFileMgr == null || this.objUserMgr == null) {
            message = "Note file cannot be opened.";
            MyNotebook.consoleOutput("MyNotebook : NotebookModel.initNoteBO() : objFileMgr and/or objUserMgr is null.");
            return message;
        }
        FOFile objNoteFile = new FOFile();
        objNoteFile.setFileName("notes.mnt");
        objNoteFile.setFileDirectory("tabs");
        this.objNoteMgr = new BONoteMgr(this.objFileMgr, objNoteFile);
        this.objNoteMgr.initFile();
        if (!this.objFileMgr.verifyFilePath(this.objNoteMgr.getFile())) {
            message = "Note file cannot be opened.";
            MyNotebook.consoleOutput("MyNotebook : NotebookModel.initNoteBO() : verifyFilePath() failed.");
            this.objNoteMgr = null;
        }
        return message;
    }

    private String saveNotebook() {
        String message = "NOMSG";
        try {
            if (this.objNoteMgr != null) {
                this.objNoteMgr.clearBusinessObjects();
                this.objNoteMgr = null;
            }
            if (this.objNotebookMgr != null) {
                this.objNotebookMgr.persistBusinessObjects();
                this.objNotebookMgr.clearBusinessObjects();
                this.objNotebookMgr = null;
            }
            if (this.objFileMgr != null) {
                this.objFileMgr = null;
            }
        }
        catch (IOException ex) {
            message = "Notebook and/or Notes did not save successfully.";
            MyNotebook.consoleOutput("MyNotebook : NotebookModel.setFilename() : Notebook and/or Note Persistance failed.");
            MyNotebook.consoleOutput(ex.toString());
        }
        return message;
    }
}

