/*
 * Decompiled with CFR 0.152.
 */
package mynotebook.view;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import mynotebook.bo.user.BOUser;
import mynotebook.controller.NotebookController;
import mynotebook.model.ModelContext;
import mynotebook.view.AbstractViewPanel;

public class AdminPanel
extends AbstractViewPanel {
    private NotebookController nc;
    private BOUser objUser;
    private JButton jButtonChangePassword;
    private JButton jButtonCreateUser;
    private JButton jButtonDeleteUser;
    private JCheckBox jCheckBoxAdmin;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabelMessages;
    private JTextField jTextFieldNewPassword;
    private JTextField jTextFieldPassword;
    private JTextField jTextFieldUserName;

    public AdminPanel(NotebookController nc, BOUser objUser) {
        this.nc = nc;
        this.objUser = objUser;
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        String pwd = System.getProperty("user.dir");
        String iconName = pwd + File.separator + "media" + File.separator + "icon-nb-2.gif";
        this.jLabel1.setIcon(new ImageIcon(iconName));
        if (this.objUser.isAdmin()) {
            this.jCheckBoxAdmin.setSelected(true);
            this.setAdminState();
        } else {
            this.jCheckBoxAdmin.setSelected(false);
            this.jTextFieldUserName.setText(this.objUser.getName());
            this.setUserState();
        }
    }

    private void setAdminState() {
        this.jButtonChangePassword.setEnabled(true);
        this.jButtonCreateUser.setEnabled(true);
        this.jButtonDeleteUser.setEnabled(true);
        this.jCheckBoxAdmin.setEnabled(true);
        this.jTextFieldUserName.setEditable(true);
    }

    private void setUserState() {
        this.jButtonChangePassword.setEnabled(true);
        this.jButtonCreateUser.setEnabled(false);
        this.jButtonDeleteUser.setEnabled(false);
        this.jCheckBoxAdmin.setEnabled(false);
        this.jTextFieldUserName.setEditable(false);
    }

    private void actionCreateUser() {
        BOUser objNewUser = new BOUser();
        objNewUser.setName(this.jTextFieldUserName.getText());
        objNewUser.setPassword(this.jTextFieldPassword.getText());
        String strAdmin = "false";
        if (this.jCheckBoxAdmin.isSelected()) {
            strAdmin = "true";
        }
        objNewUser.setAdmin(strAdmin);
        this.nc.createUser(objNewUser);
    }

    private void actionDeleteUser() {
        BOUser objDeleteUser = new BOUser();
        objDeleteUser.setName(this.jTextFieldUserName.getText());
        this.nc.deleteUser(objDeleteUser);
    }

    private void actionChangePassword() {
        BOUser objUpdatedUser = new BOUser();
        objUpdatedUser.setName(this.jTextFieldUserName.getText());
        objUpdatedUser.setPassword(this.jTextFieldNewPassword.getText());
        String strAdmin = "false";
        if (this.jCheckBoxAdmin.isSelected()) {
            strAdmin = "true";
        }
        objUpdatedUser.setAdmin(strAdmin);
        this.nc.updateUser(objUpdatedUser);
    }

    @Override
    public void modelPropertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "CreateUser": {
                this.modelPropCreateUser(evt);
                break;
            }
            case "DeleteUser": {
                this.modelPropDeleteUser(evt);
                break;
            }
            case "UpdateUser": {
                this.modelPropUpdateUser(evt);
            }
        }
        this.revalidate();
        this.repaint();
    }

    private void modelPropCreateUser(PropertyChangeEvent evt) {
        ModelContext objContext = (ModelContext)evt.getOldValue();
        String message = (String)objContext.getProperty("MODEL_CTX_MSG");
        if (!message.equals("NOMSG")) {
            this.jLabelMessages.setText(message);
        }
    }

    private void modelPropDeleteUser(PropertyChangeEvent evt) {
        ModelContext objContext = (ModelContext)evt.getOldValue();
        String message = (String)objContext.getProperty("MODEL_CTX_MSG");
        if (!message.equals("NOMSG")) {
            this.jLabelMessages.setText(message);
        }
    }

    private void modelPropUpdateUser(PropertyChangeEvent evt) {
        ModelContext objContext = (ModelContext)evt.getOldValue();
        String message = (String)objContext.getProperty("MODEL_CTX_MSG");
        if (!message.equals("NOMSG")) {
            this.jLabelMessages.setText(message);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabelMessages = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldUserName = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextFieldPassword = new JTextField();
        this.jLabel5 = new JLabel();
        this.jTextFieldNewPassword = new JTextField();
        this.jCheckBoxAdmin = new JCheckBox();
        this.jButtonCreateUser = new JButton();
        this.jButtonDeleteUser = new JButton();
        this.jButtonChangePassword = new JButton();
        this.setMaximumSize(new Dimension(250, 300));
        this.setMinimumSize(new Dimension(250, 300));
        this.jLabel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabelMessages.setFont(new Font("Tahoma", 0, 10));
        this.jLabelMessages.setBorder(BorderFactory.createTitledBorder("Messages"));
        this.jLabel3.setText("User Name");
        this.jLabel4.setText("Password");
        this.jLabel5.setText("New Password");
        this.jCheckBoxAdmin.setText("Admin");
        this.jButtonCreateUser.setText("Create User");
        this.jButtonCreateUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdminPanel.this.ActionPerformed(evt);
            }
        });
        this.jButtonDeleteUser.setText("Delete User");
        this.jButtonDeleteUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdminPanel.this.ActionPerformed(evt);
            }
        });
        this.jButtonChangePassword.setText("Change Password");
        this.jButtonChangePassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdminPanel.this.ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabelMessages, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTextFieldUserName, GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jTextFieldPassword).addComponent(this.jLabel5, -1, 200, Short.MAX_VALUE).addComponent(this.jTextFieldNewPassword).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel3, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxAdmin))).addComponent(this.jButtonChangePassword).addGroup(layout.createSequentialGroup().addComponent(this.jButtonCreateUser).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDeleteUser))).addContainerGap(-1, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jCheckBoxAdmin)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldUserName, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPassword, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldNewPassword, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCreateUser).addComponent(this.jButtonDeleteUser)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonChangePassword).addGap(17, 17, 17).addComponent(this.jLabelMessages, -2, 35, -2).addContainerGap()));
    }

    private void ActionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.jButtonCreateUser) {
            this.actionCreateUser();
        } else if (evt.getSource() == this.jButtonDeleteUser) {
            this.actionDeleteUser();
        } else if (evt.getSource() == this.jButtonChangePassword) {
            this.actionChangePassword();
        }
    }
}

