/*
 * Decompiled with CFR 0.152.
 */
package mynotebook.view;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import mynotebook.bo.note.BONote;
import mynotebook.controller.NotebookController;
import mynotebook.view.AbstractViewPanel;
import org.jdesktop.layout.GroupLayout;

public class NoteAddPanel
extends AbstractViewPanel {
    private NotebookController nc;
    private BONote objNote;
    private JButton jButtonAddNote;
    private JButton jButtonCancel;
    private JCheckBox jCheckBoxEncode;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextAreaAttachments;
    private JTextArea jTextAreaEntry;
    private JTextField jTextAuthor;
    private JTextField jTextDate;
    private JTextField jTextKeywords;
    private JTextField jTextNote;
    private JTextField jTextTab;

    public NoteAddPanel(NotebookController nc, String tab, String author) {
        this.nc = nc;
        this.initComponents();
        this.postInitComponents(tab, author);
    }

    private void postInitComponents(String tab, String author) {
        this.objNote = new BONote();
        String pwd = System.getProperty("user.dir");
        String iconName = pwd + File.separator + "media" + File.separator + "icon-nb-1.gif";
        this.jLabel1.setIcon(new ImageIcon(iconName));
        this.jTextTab.setText(tab);
        this.jTextAuthor.setText(author);
        this.jTextDate.setText(this.getTodaysDate());
        this.jTextKeywords.setText(tab);
    }

    public String getTodaysDate() {
        Date now = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd");
        String date = df.format(now);
        return date;
    }

    private void actionAddNote() {
        this.objNote.setAuthor(this.jTextAuthor.getText());
        this.objNote.setDateCreated(this.jTextDate.getText());
        this.objNote.setDateModified(this.jTextDate.getText());
        this.objNote.setEntry(this.jTextAreaEntry.getText());
        this.objNote.setKeyWords(this.jTextKeywords.getText());
        this.objNote.setName(this.jTextNote.getText());
        this.objNote.setTab(this.jTextTab.getText());
        this.objNote.setEncoded(this.jCheckBoxEncode.isSelected());
        this.nc.createNote(this.objNote);
    }

    private void actionCancel() {
        this.nc.cancelNote(this.objNote);
    }

    @Override
    public void modelPropertyChange(PropertyChangeEvent evt) {
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextNote = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextDate = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextAuthor = new JTextField();
        this.jLabel5 = new JLabel();
        this.jTextTab = new JTextField();
        this.jLabel6 = new JLabel();
        this.jTextKeywords = new JTextField();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextAreaEntry = new JTextArea();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaAttachments = new JTextArea();
        this.jButtonAddNote = new JButton();
        this.jButtonCancel = new JButton();
        this.jCheckBoxEncode = new JCheckBox();
        this.setMaximumSize(new Dimension(420, 500));
        this.setMinimumSize(new Dimension(420, 500));
        this.setPreferredSize(new Dimension(420, 500));
        this.jLabel1.setFont(new Font("Bauhaus 93", 0, 18));
        this.jLabel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setMaximumSize(new Dimension(420, 50));
        this.jLabel1.setMinimumSize(new Dimension(420, 50));
        this.jLabel1.setPreferredSize(new Dimension(420, 50));
        this.jLabel2.setText("Note");
        this.jTextNote.setFont(new Font("Courier New", 0, 12));
        this.jLabel3.setText("Date");
        this.jTextDate.setFont(new Font("Courier New", 0, 12));
        this.jTextDate.setMinimumSize(new Dimension(80, 19));
        this.jTextDate.setPreferredSize(new Dimension(80, 19));
        this.jLabel4.setText("Author");
        this.jTextAuthor.setEditable(false);
        this.jTextAuthor.setFont(new Font("Courier New", 0, 12));
        this.jTextAuthor.setMinimumSize(new Dimension(80, 19));
        this.jTextAuthor.setPreferredSize(new Dimension(80, 19));
        this.jLabel5.setText("Tab");
        this.jTextTab.setEditable(false);
        this.jTextTab.setFont(new Font("Courier New", 0, 12));
        this.jTextTab.setMinimumSize(new Dimension(80, 19));
        this.jTextTab.setPreferredSize(new Dimension(80, 19));
        this.jLabel6.setText("Keywords");
        this.jTextKeywords.setFont(new Font("Courier New", 0, 12));
        this.jLabel7.setText("Attachments");
        this.jLabel8.setText("Entry");
        this.jTextAreaEntry.setColumns(20);
        this.jTextAreaEntry.setFont(new Font("Courier New", 0, 12));
        this.jTextAreaEntry.setRows(10);
        this.jScrollPane2.setViewportView(this.jTextAreaEntry);
        this.jTextAreaAttachments.setColumns(20);
        this.jTextAreaAttachments.setFont(new Font("Courier New", 0, 12));
        this.jTextAreaAttachments.setRows(3);
        this.jScrollPane1.setViewportView(this.jTextAreaAttachments);
        this.jButtonAddNote.setText("Add Note");
        this.jButtonAddNote.setMaximumSize(new Dimension(100, 25));
        this.jButtonAddNote.setMinimumSize(new Dimension(100, 25));
        this.jButtonAddNote.setPreferredSize(new Dimension(100, 25));
        this.jButtonAddNote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NoteAddPanel.this.actionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMaximumSize(new Dimension(100, 25));
        this.jButtonCancel.setMinimumSize(new Dimension(100, 25));
        this.jButtonCancel.setPreferredSize(new Dimension(100, 25));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NoteAddPanel.this.actionPerformed(evt);
            }
        });
        this.jCheckBoxEncode.setText("Encode");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(this.jLabel1, -1, -1, Short.MAX_VALUE).add(2, layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(2).add(1, this.jScrollPane2).add(1, this.jScrollPane1).add(1, layout.createSequentialGroup().add(this.jLabel6).addPreferredGap(0).add(this.jTextKeywords)).add(1, layout.createSequentialGroup().add(this.jLabel3).addPreferredGap(0).add(this.jTextDate, -2, -1, -2).addPreferredGap(0).add(this.jLabel4).addPreferredGap(0).add(this.jTextAuthor, -2, -1, -2).addPreferredGap(0).add(this.jLabel5).addPreferredGap(0).add(this.jTextTab, -1, -1, Short.MAX_VALUE)).add(1, layout.createSequentialGroup().add(layout.createParallelGroup(2).add(1, this.jLabel8).add(1, this.jLabel7).add(1, layout.createSequentialGroup().add(this.jButtonAddNote, -2, -1, -2).addPreferredGap(0).add(this.jButtonCancel, -2, -1, -2))).add(0, 0, Short.MAX_VALUE)).add(1, layout.createSequentialGroup().add(this.jLabel2).addPreferredGap(0).add(this.jTextNote).addPreferredGap(1).add(this.jCheckBoxEncode))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.jLabel1, -2, -1, -2).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jButtonAddNote, -2, -1, -2).add(this.jButtonCancel, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel2).add(this.jTextNote, -2, -1, -2).add(this.jCheckBoxEncode)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jTextDate, -2, -1, -2).add(this.jLabel3).add(this.jLabel4).add(this.jTextAuthor, -2, -1, -2).add(this.jLabel5).add(this.jTextTab, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel6).add(this.jTextKeywords, -2, -1, -2)).addPreferredGap(0).add(this.jLabel7).addPreferredGap(0).add(this.jScrollPane1, -2, -1, -2).addPreferredGap(0).add(this.jLabel8).addPreferredGap(0).add(this.jScrollPane2, -1, 231, Short.MAX_VALUE).addContainerGap()));
    }

    private void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.jButtonAddNote) {
            this.actionAddNote();
        } else if (evt.getSource() == this.jButtonCancel) {
            this.actionCancel();
        }
    }
}

