/*
 * Decompiled with CFR 0.152.
 */
package mynotebook.view;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import mynotebook.bo.user.BOUser;
import mynotebook.controller.NotebookController;
import mynotebook.model.ModelContext;
import mynotebook.view.AbstractViewPanel;

public class NotebookLogonPanel
extends AbstractViewPanel {
    private NotebookController nc;
    private BOUser objUser;
    private JButton jButtonCancel;
    private JButton jButtonLogon;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabelMessage;
    private JPasswordField jPasswordFieldPassword;
    private JTextField jTextFieldUserName;

    public NotebookLogonPanel(NotebookController nc) {
        this.nc = nc;
        this.objUser = new BOUser();
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        String pwd = System.getProperty("user.dir");
        String iconName = new String(pwd + File.separator + "media" + File.separator + "icon-nb-2.gif");
        this.jLabel1.setIcon(new ImageIcon(iconName));
        this.jLabelMessage.setText("");
    }

    private String convertPassword(char[] pw) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < pw.length; ++i) {
            sb.append(pw[i]);
            pw[i] = 48;
        }
        return sb.toString();
    }

    private void actionLogon() {
        this.objUser.setName(this.jTextFieldUserName.getText());
        this.objUser.setPassword(this.convertPassword(this.jPasswordFieldPassword.getPassword()));
        this.nc.readUser(this.objUser);
    }

    private void actionCancel() {
        this.nc.cancelUser();
    }

    @Override
    public void modelPropertyChange(PropertyChangeEvent evt) {
        this.jLabelMessage.setText("");
        switch (evt.getPropertyName()) {
            case "ReadUser": {
                this.modelPropOpenUser(evt);
                break;
            }
            case "CancelUser": {
                this.modelPropCancelUser(evt);
            }
        }
        this.revalidate();
        this.repaint();
    }

    private void modelPropOpenUser(PropertyChangeEvent evt) {
        ModelContext objContext = (ModelContext)evt.getOldValue();
        String message = (String)objContext.getProperty("MODEL_CTX_MSG");
        if (!message.equals("NOMSG")) {
            this.objUser.setName("");
            this.objUser.setPassword("");
            this.jTextFieldUserName.setText("");
            this.jPasswordFieldPassword.setText("");
            this.jLabelMessage.setText(message);
        }
    }

    private void modelPropCancelUser(PropertyChangeEvent evt) {
        ModelContext objContext = (ModelContext)evt.getOldValue();
        String message = (String)objContext.getProperty("MODEL_CTX_MSG");
        this.objUser.setName("");
        this.objUser.setPassword("");
        this.jTextFieldUserName.setText("");
        this.jPasswordFieldPassword.setText("");
        this.jLabelMessage.setText(message);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldUserName = new JTextField();
        this.jLabel3 = new JLabel();
        this.jPasswordFieldPassword = new JPasswordField();
        this.jButtonLogon = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabel4 = new JLabel();
        this.jLabelMessage = new JLabel();
        this.setMaximumSize(new Dimension(250, 300));
        this.setMinimumSize(new Dimension(250, 300));
        this.jLabel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setMaximumSize(new Dimension(250, 40));
        this.jLabel1.setMinimumSize(new Dimension(250, 40));
        this.jLabel1.setPreferredSize(new Dimension(250, 40));
        this.jLabel2.setText("User Name");
        this.jTextFieldUserName.setFont(new Font("Courier New", 0, 12));
        this.jTextFieldUserName.setMaximumSize(new Dimension(200, 20));
        this.jTextFieldUserName.setMinimumSize(new Dimension(200, 20));
        this.jTextFieldUserName.setPreferredSize(new Dimension(200, 20));
        this.jLabel3.setText("Password");
        this.jPasswordFieldPassword.setFont(new Font("Courier New", 0, 12));
        this.jPasswordFieldPassword.setMaximumSize(new Dimension(200, 20));
        this.jPasswordFieldPassword.setMinimumSize(new Dimension(200, 20));
        this.jPasswordFieldPassword.setPreferredSize(new Dimension(200, 20));
        this.jButtonLogon.setText("Logon");
        this.jButtonLogon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotebookLogonPanel.this.actionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotebookLogonPanel.this.actionPerformed(evt);
            }
        });
        this.jLabel4.setFont(new Font("Courier New", 0, 12));
        this.jLabelMessage.setFont(new Font("Tahoma", 0, 10));
        this.jLabelMessage.setHorizontalAlignment(2);
        this.jLabelMessage.setBorder(BorderFactory.createTitledBorder("Messages"));
        this.jLabelMessage.setHorizontalTextPosition(0);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3).addGroup(layout.createSequentialGroup().addComponent(this.jButtonLogon).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPasswordFieldPassword, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addGap(22, 22, 22)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelMessage, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jTextFieldUserName, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -2, 14, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldUserName, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPasswordFieldPassword, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonLogon).addComponent(this.jButtonCancel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 82, Short.MAX_VALUE).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelMessage, -2, 35, -2).addContainerGap()));
    }

    private void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.jButtonLogon) {
            this.actionLogon();
        } else if (evt.getSource() == this.jButtonCancel) {
            this.actionCancel();
        }
    }
}

