/*
 * Decompiled with CFR 0.152.
 */
package mynotebook.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mynotebook.bo.notebook.BONotebook;
import mynotebook.bo.tab.BONotebookTab;
import mynotebook.bo.user.BOUser;
import mynotebook.controller.NotebookController;
import mynotebook.model.ModelContext;
import mynotebook.view.AbstractViewPanel;
import mynotebook.view.AdminPanel;
import mynotebook.view.NotebookFileFilter;
import mynotebook.view.NotebookLogonPanel;
import mynotebook.view.NotesTabPanel;
import mynotebook.view.TabAddPanel;
import org.jdesktop.layout.GroupLayout;

public class NotebookPanel
extends AbstractViewPanel {
    private BONotebook objNotebook;
    private BOUser objUser;
    private NotebookController nc;
    private JFileChooser fc;
    private JFrame objLogonFrame;
    private NotebookLogonPanel objLogonPanel;
    private JFrame objAddTabFrame;
    private TabAddPanel objAddTabPanel;
    private JFrame objAdminFrame;
    private AdminPanel objAdminPanel;
    private TreeMap<String, NotesTabPanel> mNotesTabPanels;
    private JButton jButtonAbout;
    private JButton jButtonAddTab;
    private JButton jButtonAdmin;
    private JButton jButtonCloseNotebook;
    private JButton jButtonCreateNotebook;
    private JButton jButtonDeleteTab;
    private JButton jButtonLogOn;
    private JButton jButtonOpenNotebook;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabelMessage;
    private JLabel jLabelVersion;
    private JTabbedPane jTabbedPaneTabs;
    private JTextField jTextFieldUserName;
    private JTextField jTextNotebookName;

    public NotebookPanel(NotebookController nc, String strFOFVersion) {
        this.nc = nc;
        this.initComponents();
        this.postInitComponents(strFOFVersion);
    }

    private void postInitComponents(String strFOFVersion) {
        this.objLogonPanel = null;
        this.objLogonFrame = null;
        this.objAddTabPanel = null;
        this.objAddTabFrame = null;
        this.mNotesTabPanels = new TreeMap();
        this.fc = new JFileChooser();
        this.fc.addChoosableFileFilter(new NotebookFileFilter());
        this.fc.setAcceptAllFileFilterUsed(false);
        this.setLogoffState();
        String pwd = System.getProperty("user.dir");
        String iconName = pwd + File.separator + "media" + File.separator + "icon-nb-1.gif";
        this.jLabel1.setIcon(new ImageIcon(iconName));
        this.jLabelVersion.setText("MNB(2.5) FOF(" + strFOFVersion + ")");
    }

    private void displayLogonDialog() {
        this.disposeLogonDialog();
        this.objLogonPanel = new NotebookLogonPanel(this.nc);
        this.objLogonFrame = new JFrame("My Notebook Log On");
        this.objLogonFrame.getContentPane().add((Component)this.objLogonPanel, "Center");
        this.objLogonFrame.pack();
        this.objLogonFrame.setLocationRelativeTo(this);
        this.objLogonFrame.setVisible(true);
        this.nc.addView(this.objLogonPanel);
    }

    private void disposeLogonDialog() {
        if (this.objLogonPanel != null) {
            this.nc.removeView(this.objLogonPanel);
        }
        if (this.objLogonFrame != null) {
            this.objLogonFrame.setVisible(false);
            this.objLogonFrame.dispose();
        }
        this.objLogonPanel = null;
        this.objLogonFrame = null;
    }

    private void displayAddTabDialog() {
        this.disposeAddTabDialog();
        this.objAddTabPanel = new TabAddPanel(this.nc);
        this.objAddTabFrame = new JFrame("My Notebook Add Tab");
        this.objAddTabFrame.getContentPane().add((Component)this.objAddTabPanel, "Center");
        this.objAddTabFrame.pack();
        this.objAddTabFrame.setLocationRelativeTo(this);
        this.objAddTabFrame.setVisible(true);
        this.nc.addView(this.objAddTabPanel);
    }

    private void disposeAddTabDialog() {
        if (this.objAddTabPanel != null) {
            this.nc.removeView(this.objAddTabPanel);
        }
        if (this.objAddTabFrame != null) {
            this.objAddTabFrame.setVisible(false);
            this.objAddTabFrame.dispose();
        }
        this.objAddTabPanel = null;
        this.objAddTabFrame = null;
    }

    private void displayAdminDialog() {
        this.disposeAdminDialog();
        this.objAdminPanel = new AdminPanel(this.nc, this.objUser);
        this.objAdminFrame = new JFrame("My Notebook Admin");
        this.objAdminFrame.getContentPane().add((Component)this.objAdminPanel, "Center");
        this.objAdminFrame.pack();
        this.objAdminFrame.setLocationRelativeTo(this);
        this.objAdminFrame.setVisible(true);
        this.nc.addView(this.objAdminPanel);
    }

    private void disposeAdminDialog() {
        if (this.objAdminPanel != null) {
            this.nc.removeView(this.objAdminPanel);
        }
        if (this.objAdminFrame != null) {
            this.objAdminFrame.setVisible(false);
            this.objAdminFrame.dispose();
        }
        this.objAdminPanel = null;
        this.objAdminFrame = null;
    }

    private void displayInfoDialog(String strMessage) {
        JOptionPane objOptionPane = new JOptionPane();
        JOptionPane.showMessageDialog(this, strMessage, "MyNotebook", 1);
    }

    private int displayOptionDialog(String strMessage) {
        JOptionPane objOptionPane = new JOptionPane();
        return JOptionPane.showConfirmDialog(this, strMessage, "MyNotebook Option", 0);
    }

    private void setLogoffState() {
        this.jButtonAdmin.setEnabled(false);
        this.jButtonCreateNotebook.setEnabled(false);
        this.jButtonOpenNotebook.setEnabled(false);
        this.jButtonCloseNotebook.setEnabled(false);
        this.jButtonAddTab.setEnabled(false);
        this.jButtonDeleteTab.setEnabled(false);
        this.jButtonLogOn.setText("Log On");
        this.jTextNotebookName.setEditable(false);
        this.jTextNotebookName.setText("");
        this.jTextFieldUserName.setText("");
        this.jTabbedPaneTabs.setSelectedIndex(-1);
        this.jTabbedPaneTabs.removeAll();
    }

    private void setLogonState() {
        this.jButtonAdmin.setEnabled(true);
        this.jButtonCreateNotebook.setEnabled(true);
        this.jButtonOpenNotebook.setEnabled(true);
        this.jButtonCloseNotebook.setEnabled(false);
        this.jButtonAddTab.setEnabled(false);
        this.jButtonDeleteTab.setEnabled(false);
        this.jButtonLogOn.setText("Log Off");
        this.jTextNotebookName.setEditable(false);
        this.jTextNotebookName.setText("");
        this.jTextFieldUserName.setText("");
        this.jTabbedPaneTabs.setSelectedIndex(-1);
        this.jTabbedPaneTabs.removeAll();
    }

    private void setNotebookOpenState() {
        this.jButtonAdmin.setEnabled(true);
        this.jButtonCreateNotebook.setEnabled(false);
        this.jButtonOpenNotebook.setEnabled(false);
        this.jButtonCloseNotebook.setEnabled(true);
        this.jButtonAddTab.setEnabled(true);
        this.jButtonDeleteTab.setEnabled(true);
        this.jButtonLogOn.setText("Log Off");
        this.jTextNotebookName.setEditable(false);
        this.jTextNotebookName.setText("");
        this.jTextFieldUserName.setText("");
    }

    private void setNotebookClosedState() {
        this.jButtonAdmin.setEnabled(true);
        this.jButtonCreateNotebook.setEnabled(true);
        this.jButtonOpenNotebook.setEnabled(true);
        this.jButtonCloseNotebook.setEnabled(false);
        this.jButtonAddTab.setEnabled(false);
        this.jButtonDeleteTab.setEnabled(false);
        this.jButtonLogOn.setText("Log Off");
        this.jTextNotebookName.setEditable(false);
        this.jTextNotebookName.setText("");
        this.jTextFieldUserName.setText("");
        this.jTabbedPaneTabs.setSelectedIndex(-1);
        this.jTabbedPaneTabs.removeAll();
    }

    private void setTabs(ArrayList<BONotebookTab> aTabs) {
        this.closeTabs();
        for (BONotebookTab objTab : aTabs) {
            NotesTabPanel objNotesTabPanel = new NotesTabPanel(this.nc, objTab, this.objUser);
            this.mNotesTabPanels.put(objTab.getNotebookTabID(), objNotesTabPanel);
            this.jTabbedPaneTabs.addTab(objTab.getTabName(), null, objNotesTabPanel, objTab.getTabName());
            this.nc.addView(objNotesTabPanel);
        }
        if (aTabs.size() > 0) {
            this.jTabbedPaneTabs.setSelectedIndex(0);
        } else {
            this.jTabbedPaneTabs.setSelectedIndex(-1);
        }
    }

    private void closeTabs() {
        for (Map.Entry<String, NotesTabPanel> entry : this.mNotesTabPanels.entrySet()) {
            String strTabID = entry.getKey();
            NotesTabPanel objNotesTabPanel = entry.getValue();
            if (objNotesTabPanel == null) continue;
            BONotebookTab objTab = objNotesTabPanel.getTab();
            this.nc.closeTab(objTab);
            this.nc.removeView(objNotesTabPanel);
        }
        this.mNotesTabPanels.clear();
        this.jTabbedPaneTabs.removeAll();
    }

    private void actionLogonUser() {
        this.displayLogonDialog();
    }

    private void actionLogoffUser() {
        int intOption = this.displayOptionDialog("Are you sure you want to log off?");
        if (intOption == 0) {
            this.actionCloseNotebook();
            this.nc.closeUser(this.objUser);
        }
    }

    private void actionAdmin() {
        this.displayAdminDialog();
    }

    private void actionAbout() {
        this.displayInfoDialog("My Notebook - by Charles Weddle - www.charlesweddle.com");
    }

    private void actionCreateNotebook() {
        int ret = this.fc.showOpenDialog(this);
        if (ret == 0) {
            File f = this.fc.getSelectedFile();
            String path = f.getAbsolutePath();
            this.nc.createNotebook(path);
        }
    }

    private void actionOpenNotebook() {
        int ret = this.fc.showOpenDialog(this);
        if (ret == 0) {
            File f = this.fc.getSelectedFile();
            String path = f.getAbsolutePath();
            this.nc.readNotebook(path);
            for (Map.Entry<String, NotesTabPanel> entry : this.mNotesTabPanels.entrySet()) {
                String strTabID = entry.getKey();
                NotesTabPanel objNotesTabPanel = entry.getValue();
                if (!objNotesTabPanel.isShowing()) continue;
                BONotebookTab objNotebookTab = objNotesTabPanel.getTab();
                this.nc.readTab(objNotebookTab);
                break;
            }
        }
    }

    private void actionConfirmCloseNotebook() {
        int intOption = this.displayOptionDialog("Are you sure you want to close the notebook?");
        if (intOption == 0) {
            this.actionCloseNotebook();
        }
    }

    private void actionCloseNotebook() {
        if (this.objNotebook != null) {
            this.nc.closeNotebook(this.objNotebook);
        }
    }

    private void actionAddTab() {
        this.displayAddTabDialog();
    }

    private void actionDeleteTab() {
        if (this.jTabbedPaneTabs.getSelectedIndex() != -1) {
            NotesTabPanel objPanel = (NotesTabPanel)this.jTabbedPaneTabs.getSelectedComponent();
            BONotebookTab objTab = objPanel.getTab();
            int intOption = this.displayOptionDialog("Are you sure you want to delete the " + objTab.getTabName() + " tab?");
            if (intOption == 0) {
                this.nc.deleteTab(objTab);
                for (Map.Entry<String, NotesTabPanel> entry : this.mNotesTabPanels.entrySet()) {
                    String strTabID = entry.getKey();
                    NotesTabPanel objNotesTabPanel = entry.getValue();
                    if (!objNotesTabPanel.isShowing()) continue;
                    BONotebookTab objNotebookTab = objNotesTabPanel.getTab();
                    this.nc.readTab(objNotebookTab);
                    break;
                }
            }
        }
    }

    @Override
    public void modelPropertyChange(PropertyChangeEvent evt) {
        this.jLabelMessage.setText("Welcome To My Notebook!");
        switch (evt.getPropertyName()) {
            case "CreateNotebook": {
                this.modelPropCreateNotebook(evt);
                break;
            }
            case "ReadNotebook": {
                this.modelPropReadNotebook(evt);
                break;
            }
            case "UpdateNotebook": {
                this.modelPropUpdateNotebook(evt);
                break;
            }
            case "DeleteNotebook": {
                this.modelPropDeleteNotebook(evt);
                break;
            }
            case "CloseNotebook": {
                this.modelPropCloseNotebook(evt);
                break;
            }
            case "CreateTab": {
                this.modelPropCreateTab(evt);
                break;
            }
            case "ReadTab": {
                this.modelPropReadTab(evt);
                break;
            }
            case "UpdateTab": {
                this.modelPropUpdateTab(evt);
                break;
            }
            case "DeleteTab": {
                this.modelPropDeleteTab(evt);
                break;
            }
            case "CloseTab": {
                this.modelPropCloseTab(evt);
                break;
            }
            case "CancelTab": {
                this.modelPropCancelTab(evt);
                break;
            }
            case "CreateNote": {
                this.modelPropCreateNote(evt);
                break;
            }
            case "ReadNote": {
                this.modelPropReadNote(evt);
                break;
            }
            case "UpdateNote": {
                this.modelPropUpdateNote(evt);
                break;
            }
            case "DeleteNote": {
                this.modelPropDeleteNote(evt);
                break;
            }
            case "CloseNote": {
                this.modelPropCloseNote(evt);
                break;
            }
            case "CreateUser": {
                this.modelPropCreateUser(evt);
                break;
            }
            case "ReadUser": {
                this.modelPropReadUser(evt);
                break;
            }
            case "UpdateUser": {
                this.modelPropUpdateUser(evt);
                break;
            }
            case "DeleteUser": {
                this.modelPropDeleteUser(evt);
                break;
            }
            case "CloseUser": {
                this.modelPropCloseUser(evt);
                break;
            }
            case "CancelUser": {
                this.modelPropCancelUser(evt);
            }
        }
        this.revalidate();
        this.repaint();
    }

    private void modelPropCreateNotebook(PropertyChangeEvent evt) {
        ModelContext objContext = (ModelContext)evt.getOldValue();
        String message = (String)objContext.getProperty("MODEL_CTX_MSG");
        if (!message.equals("NOMSG")) {
            this.jLabelMessage.setText(message);
            this.setNotebookClosedState();
            return;
        }
        this.objNotebook = (BONotebook)objContext.getProperty("MODEL_CTX_B");
        if (this.objNotebook != null) {
            this.setNotebookOpenState();
            this.jTextNotebookName.setText(this.objNotebook.getNotebookName());
            this.jLabelMessage.setText("Notebook " + this.objNotebook.getNotebookName() + " has been created.");
        }
    }

    private void modelPropReadNotebook(PropertyChangeEvent evt) {
        ModelContext objContext = (ModelContext)evt.getOldValue();
        String message = (String)objContext.getProperty("MODEL_CTX_MSG");
        if (!message.equals("NOMSG")) {
            this.jLabelMessage.setText(message);
            this.setNotebookClosedState();
            return;
        }
        this.objNotebook = (BONotebook)objContext.getProperty("MODEL_CTX_B");
        if (this.objNotebook != null) {
            ArrayList aTabs = (ArrayList)objContext.getProperty("MODEL_CTX_C");
            this.setTabs(aTabs);
            this.setNotebookOpenState();
            this.jTextNotebookName.setText(this.objNotebook.getNotebookName());
            this.jLabelMessage.setText("Notebook " + this.objNotebook.getNotebookName() + " has been opened.");
        }
    }

    private void modelPropUpdateNotebook(PropertyChangeEvent evt) {
    }

    private void modelPropDeleteNotebook(PropertyChangeEvent evt) {
    }

    private void modelPropCloseNotebook(PropertyChangeEvent evt) {
        ModelContext objContext = (ModelContext)evt.getOldValue();
        String message = (String)objContext.getProperty("MODEL_CTX_MSG");
        if (!message.equals("NOMSG")) {
            this.jLabelMessage.setText(message);
        } else {
            this.closeTabs();
            this.setNotebookClosedState();
            this.jLabelMessage.setText("The notebook has been closed.");
            this.objNotebook = null;
        }
    }

    private void modelPropCreateTab(PropertyChangeEvent evt) {
        ModelContext objContext = (ModelContext)evt.getOldValue();
        String message = (String)objContext.getProperty("MODEL_CTX_MSG");
        if (!message.equals("NOMSG")) {
            this.jLabelMessage.setText(message);
            return;
        }
        this.disposeAddTabDialog();
        BONotebookTab objNewTab = (BONotebookTab)objContext.getProperty("MODEL_CTX_A");
        ArrayList aTabs = (ArrayList)objContext.getProperty("MODEL_CTX_B");
        this.setTabs(aTabs);
        this.jLabelMessage.setText("Tab " + objNewTab.getTabName() + " has been added.");
    }

    private void modelPropReadTab(PropertyChangeEvent evt) {
    }

    private void modelPropUpdateTab(PropertyChangeEvent evt) {
    }

    private void modelPropDeleteTab(PropertyChangeEvent evt) {
        ModelContext objContext = (ModelContext)evt.getOldValue();
        String message = (String)objContext.getProperty("MODEL_CTX_MSG");
        if (!message.equals("NOMSG")) {
            this.jLabelMessage.setText(message);
            return;
        }
        BONotebookTab objDeletedTab = (BONotebookTab)objContext.getProperty("MODEL_CTX_A");
        ArrayList aTabs = (ArrayList)objContext.getProperty("MODEL_CTX_B");
        this.setTabs(aTabs);
        this.jLabelMessage.setText("Tab " + objDeletedTab.getTabName() + " has been deleted.");
    }

    private void modelPropCloseTab(PropertyChangeEvent evt) {
    }

    private void modelPropCancelTab(PropertyChangeEvent evt) {
        ModelContext objContext = (ModelContext)evt.getOldValue();
        String message = (String)objContext.getProperty("MODEL_CTX_MSG");
        if (!message.equals("NOMSG")) {
            this.jLabelMessage.setText(message);
        }
        this.disposeAddTabDialog();
    }

    private void modelPropCreateNote(PropertyChangeEvent evt) {
    }

    private void modelPropReadNote(PropertyChangeEvent evt) {
    }

    private void modelPropUpdateNote(PropertyChangeEvent evt) {
    }

    private void modelPropDeleteNote(PropertyChangeEvent evt) {
        ModelContext objContext = (ModelContext)evt.getOldValue();
        String message = (String)objContext.getProperty("MODEL_CTX_MSG");
        if (!message.equals("NOMSG")) {
            this.jLabelMessage.setText(message);
        }
    }

    private void modelPropCloseNote(PropertyChangeEvent evt) {
    }

    private void modelPropCreateUser(PropertyChangeEvent evt) {
        ModelContext objContext = (ModelContext)evt.getOldValue();
        String message = (String)objContext.getProperty("MODEL_CTX_MSG");
        if (!message.equals("NOMSG")) {
            return;
        }
        this.disposeAdminDialog();
        BOUser objCreatedUser = (BOUser)objContext.getProperty("MODEL_CTX_A");
        if (objCreatedUser != null) {
            this.jLabelMessage.setText("User " + objCreatedUser.getName() + " has been created.");
        }
    }

    private void modelPropReadUser(PropertyChangeEvent evt) {
        ModelContext objContext = (ModelContext)evt.getOldValue();
        String message = (String)objContext.getProperty("MODEL_CTX_MSG");
        if (!message.equals("NOMSG")) {
            return;
        }
        this.disposeLogonDialog();
        this.objUser = (BOUser)objContext.getProperty("MODEL_CTX_A");
        if (this.objUser != null) {
            this.setLogonState();
            this.jTextFieldUserName.setText(this.objUser.getName());
            this.jLabelMessage.setText("User " + this.objUser.getName() + " has logged into MyNotebook.");
        }
    }

    private void modelPropUpdateUser(PropertyChangeEvent evt) {
        ModelContext objContext = (ModelContext)evt.getOldValue();
        String message = (String)objContext.getProperty("MODEL_CTX_MSG");
        if (!message.equals("NOMSG")) {
            return;
        }
        this.disposeAdminDialog();
        BOUser objUpdatedUser = (BOUser)objContext.getProperty("MODEL_CTX_A");
        if (objUpdatedUser != null) {
            this.jLabelMessage.setText("User " + objUpdatedUser.getName() + " has been updated.");
        }
    }

    private void modelPropDeleteUser(PropertyChangeEvent evt) {
        ModelContext objContext = (ModelContext)evt.getOldValue();
        String message = (String)objContext.getProperty("MODEL_CTX_MSG");
        if (!message.equals("NOMSG")) {
            return;
        }
        this.disposeAdminDialog();
        BOUser objDeletedUser = (BOUser)objContext.getProperty("MODEL_CTX_A");
        if (objDeletedUser != null) {
            this.jLabelMessage.setText("User " + objDeletedUser.getName() + " has been deleted.");
        }
    }

    private void modelPropCloseUser(PropertyChangeEvent evt) {
        ModelContext objContext = (ModelContext)evt.getOldValue();
        String message = (String)objContext.getProperty("MODEL_CTX_MSG");
        if (!message.equals("NOMSG")) {
            this.jLabelMessage.setText(message);
            return;
        }
        BOUser objClosedUser = (BOUser)objContext.getProperty("MODEL_CTX_A");
        if (objClosedUser != null) {
            this.jLabelMessage.setText("User " + this.objUser.getName() + " has logged out of MyNotebook.");
        }
        this.objUser = null;
        this.setLogoffState();
    }

    private void modelPropCancelUser(PropertyChangeEvent evt) {
        ModelContext objContext = (ModelContext)evt.getOldValue();
        String message = (String)objContext.getProperty("MODEL_CTX_MSG");
        if (!message.equals("NOMSG")) {
            this.jLabelMessage.setText(message);
        }
        this.disposeLogonDialog();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextNotebookName = new JTextField();
        this.jButtonOpenNotebook = new JButton();
        this.jTabbedPaneTabs = new JTabbedPane();
        this.jButtonCloseNotebook = new JButton();
        this.jButtonAddTab = new JButton();
        this.jButtonDeleteTab = new JButton();
        this.jButtonCreateNotebook = new JButton();
        this.jButtonLogOn = new JButton();
        this.jTextFieldUserName = new JTextField();
        this.jLabel3 = new JLabel();
        this.jButtonAdmin = new JButton();
        this.jButtonAbout = new JButton();
        this.jLabelVersion = new JLabel();
        this.jLabelMessage = new JLabel();
        this.setMaximumSize(new Dimension(420, 500));
        this.setMinimumSize(new Dimension(420, 500));
        this.setPreferredSize(new Dimension(420, 500));
        this.jLabel1.setFont(new Font("Bauhaus 93", 0, 18));
        this.jLabel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel2.setText("Tabs");
        this.jLabel4.setText("Notebook");
        this.jTextNotebookName.setEditable(false);
        this.jTextNotebookName.setFont(new Font("Courier New", 0, 12));
        this.jButtonOpenNotebook.setText("Open Notebook");
        this.jButtonOpenNotebook.setEnabled(false);
        this.jButtonOpenNotebook.setMargin(new Insets(2, 5, 2, 5));
        this.jButtonOpenNotebook.setMaximumSize(new Dimension(110, 25));
        this.jButtonOpenNotebook.setMinimumSize(new Dimension(110, 25));
        this.jButtonOpenNotebook.setPreferredSize(new Dimension(110, 25));
        this.jButtonOpenNotebook.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotebookPanel.this.actionPerformed(evt);
            }
        });
        this.jTabbedPaneTabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                NotebookPanel.this.tabStateChange(evt);
            }
        });
        this.jButtonCloseNotebook.setText("Close Notebook");
        this.jButtonCloseNotebook.setEnabled(false);
        this.jButtonCloseNotebook.setMargin(new Insets(2, 5, 2, 5));
        this.jButtonCloseNotebook.setMaximumSize(new Dimension(110, 25));
        this.jButtonCloseNotebook.setMinimumSize(new Dimension(110, 25));
        this.jButtonCloseNotebook.setPreferredSize(new Dimension(110, 25));
        this.jButtonCloseNotebook.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotebookPanel.this.actionPerformed(evt);
            }
        });
        this.jButtonAddTab.setText("Add Tab");
        this.jButtonAddTab.setEnabled(false);
        this.jButtonAddTab.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonAddTab.setMaximumSize(new Dimension(110, 25));
        this.jButtonAddTab.setMinimumSize(new Dimension(110, 25));
        this.jButtonAddTab.setPreferredSize(new Dimension(110, 25));
        this.jButtonAddTab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotebookPanel.this.actionPerformed(evt);
            }
        });
        this.jButtonDeleteTab.setText("Delete Tab");
        this.jButtonDeleteTab.setEnabled(false);
        this.jButtonDeleteTab.setMaximumSize(new Dimension(110, 25));
        this.jButtonDeleteTab.setMinimumSize(new Dimension(110, 25));
        this.jButtonDeleteTab.setPreferredSize(new Dimension(110, 25));
        this.jButtonDeleteTab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotebookPanel.this.actionPerformed(evt);
            }
        });
        this.jButtonCreateNotebook.setText("Create Notebook");
        this.jButtonCreateNotebook.setEnabled(false);
        this.jButtonCreateNotebook.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonCreateNotebook.setMaximumSize(new Dimension(110, 25));
        this.jButtonCreateNotebook.setMinimumSize(new Dimension(110, 25));
        this.jButtonCreateNotebook.setPreferredSize(new Dimension(110, 25));
        this.jButtonCreateNotebook.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotebookPanel.this.actionPerformed(evt);
            }
        });
        this.jButtonLogOn.setText("Log On");
        this.jButtonLogOn.setMaximumSize(new Dimension(110, 25));
        this.jButtonLogOn.setMinimumSize(new Dimension(110, 25));
        this.jButtonLogOn.setPreferredSize(new Dimension(110, 25));
        this.jButtonLogOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotebookPanel.this.actionPerformed(evt);
            }
        });
        this.jTextFieldUserName.setEditable(false);
        this.jLabel3.setText("User");
        this.jButtonAdmin.setText("Administration");
        this.jButtonAdmin.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonAdmin.setMaximumSize(new Dimension(110, 25));
        this.jButtonAdmin.setMinimumSize(new Dimension(110, 25));
        this.jButtonAdmin.setPreferredSize(new Dimension(110, 25));
        this.jButtonAdmin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotebookPanel.this.actionPerformed(evt);
            }
        });
        this.jButtonAbout.setText("About");
        this.jButtonAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotebookPanel.this.actionPerformed(evt);
            }
        });
        this.jLabelVersion.setFont(new Font("Tahoma", 1, 10));
        this.jLabelVersion.setHorizontalAlignment(0);
        this.jLabelVersion.setText("version");
        this.jLabelMessage.setHorizontalAlignment(0);
        this.jLabelMessage.setText("Welcome to MyNotebook!");
        this.jLabelMessage.setBorder(BorderFactory.createTitledBorder("Messages"));
        this.jLabelMessage.setHorizontalTextPosition(0);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(this.jLabel1, -1, -1, Short.MAX_VALUE).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.jTabbedPaneTabs).add(layout.createSequentialGroup().add(this.jLabel4).addPreferredGap(0).add(this.jTextNotebookName)).add(layout.createSequentialGroup().add(this.jLabel3).addPreferredGap(0).add(this.jTextFieldUserName)).add(layout.createSequentialGroup().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.jButtonAddTab, -2, -1, -2).addPreferredGap(0).add(this.jButtonDeleteTab, -2, -1, -2)).add(this.jLabel2).add(layout.createSequentialGroup().add(this.jButtonCreateNotebook, -2, -1, -2).addPreferredGap(0).add(this.jButtonOpenNotebook, -2, -1, -2).addPreferredGap(0).add(this.jButtonCloseNotebook, -2, -1, -2)).add(layout.createSequentialGroup().add(this.jButtonLogOn, -2, -1, -2).addPreferredGap(0).add(this.jButtonAdmin, -2, -1, -2).addPreferredGap(0).add(this.jButtonAbout, -2, 110, -2))).add(0, 58, Short.MAX_VALUE)).add(layout.createSequentialGroup().add(this.jLabelMessage, -2, 272, -2).addPreferredGap(0).add(this.jLabelVersion, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().add(this.jLabel1, -2, 50, -2).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabelMessage).add(this.jLabelVersion)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jButtonLogOn, -2, -1, -2).add(this.jButtonAdmin, -2, -1, -2).add(this.jButtonAbout)).addPreferredGap(0).add(layout.createParallelGroup(1).add(2, this.jLabel3).add(2, this.jTextFieldUserName, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(1).add(2, this.jLabel4).add(2, layout.createSequentialGroup().add(layout.createParallelGroup(3).add(this.jButtonCreateNotebook, -2, -1, -2).add(this.jButtonOpenNotebook, -2, -1, -2).add(this.jButtonCloseNotebook, -2, -1, -2)).addPreferredGap(0).add(this.jTextNotebookName, -2, -1, -2))).addPreferredGap(0).add(this.jLabel2, -2, 14, -2).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jButtonAddTab, -2, -1, -2).add(this.jButtonDeleteTab, -2, -1, -2)).addPreferredGap(1).add(this.jTabbedPaneTabs, -1, 221, Short.MAX_VALUE).add(10, 10, 10)));
    }

    private void tabStateChange(ChangeEvent evt) {
        if (this.jTabbedPaneTabs.getSelectedIndex() != -1) {
            NotesTabPanel objPanel = (NotesTabPanel)this.jTabbedPaneTabs.getSelectedComponent();
            BONotebookTab objTab = objPanel.getTab();
            this.nc.readTab(objTab);
        }
    }

    private void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.jButtonLogOn) {
            if (this.objUser == null) {
                this.actionLogonUser();
            } else {
                this.actionLogoffUser();
            }
        } else if (evt.getSource() == this.jButtonAdmin) {
            this.actionAdmin();
        } else if (evt.getSource() == this.jButtonAbout) {
            this.actionAbout();
        } else if (evt.getSource() == this.jButtonCreateNotebook) {
            this.actionCreateNotebook();
        } else if (evt.getSource() == this.jButtonOpenNotebook) {
            this.actionOpenNotebook();
        } else if (evt.getSource() == this.jButtonCloseNotebook) {
            this.actionConfirmCloseNotebook();
        } else if (evt.getSource() == this.jButtonAddTab) {
            this.actionAddTab();
        } else if (evt.getSource() == this.jButtonDeleteTab) {
            this.actionDeleteTab();
        }
    }
}

