/*
 * Decompiled with CFR 0.152.
 */
package mynotebook.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mynotebook.bo.note.BONote;
import mynotebook.bo.note.BONotebookNote;
import mynotebook.bo.tab.BONotebookTab;
import mynotebook.bo.user.BOUser;
import mynotebook.controller.NotebookController;
import mynotebook.model.ModelContext;
import mynotebook.view.AbstractViewPanel;
import mynotebook.view.NoteAddPanel;
import mynotebook.view.NoteViewPanel;
import mynotebook.view.NotesListCellRenderer;
import org.jdesktop.layout.GroupLayout;

public class NotesTabPanel
extends AbstractViewPanel {
    private NotebookController nc;
    private DefaultListModel nlm;
    private NoteAddPanel objNoteAddPanel;
    private JFrame objNoteAddFrame;
    private BONotebookTab objTab;
    private BOUser objUser;
    private TreeMap<String, JFrame> mNoteViewFrames;
    private TreeMap<String, NoteViewPanel> mNoteViewPanels;
    private JButton jButtonAddNote;
    private JButton jButtonDeleteNote;
    private JLabel jLabel1;
    private JList jListNotes;
    private JScrollPane jScrollPane1;

    public NotesTabPanel(NotebookController nc, BONotebookTab objTab, BOUser objUser) {
        this.nc = nc;
        this.objTab = objTab;
        this.objUser = objUser;
        this.mNoteViewFrames = new TreeMap();
        this.mNoteViewPanels = new TreeMap();
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.nlm = new DefaultListModel();
        this.jListNotes.setCellRenderer(new NotesListCellRenderer());
        this.jListNotes.setModel(this.nlm);
    }

    public BONotebookTab getTab() {
        return this.objTab;
    }

    private void displayAddNoteDialog() {
        this.disposeAddNoteDialog();
        this.objNoteAddPanel = new NoteAddPanel(this.nc, this.objTab.getTabName(), this.objUser.getName());
        this.objNoteAddFrame = new JFrame("My Notebook Add Note");
        this.objNoteAddFrame.getContentPane().add((Component)this.objNoteAddPanel, "Center");
        this.objNoteAddFrame.pack();
        this.objNoteAddFrame.setLocationRelativeTo(null);
        this.objNoteAddFrame.setVisible(true);
        this.nc.addView(this.objNoteAddPanel);
    }

    private void disposeAddNoteDialog() {
        if (this.objNoteAddPanel != null) {
            this.nc.removeView(this.objNoteAddPanel);
        }
        if (this.objNoteAddFrame != null) {
            this.objNoteAddFrame.setVisible(false);
            this.objNoteAddFrame.dispose();
        }
        this.objNoteAddPanel = null;
        this.objNoteAddFrame = null;
    }

    private int displayOptionDialog(String strMessage) {
        JOptionPane objOptionPane = new JOptionPane();
        return JOptionPane.showConfirmDialog(this, strMessage, "MyNotebook Option", 0);
    }

    private void addNotesToTab(ArrayList<BONotebookNote> aNotebookNotes) {
        this.jListNotes.setSelectedIndex(-1);
        this.nlm.removeAllElements();
        for (BONotebookNote objNotebookNote : aNotebookNotes) {
            if (!objNotebookNote.getTab().equals(this.objTab.getTabName())) continue;
            this.nlm.addElement(objNotebookNote);
        }
    }

    private boolean setNoteViewInFocus(BONote objNote) {
        for (Map.Entry<String, JFrame> entry : this.mNoteViewFrames.entrySet()) {
            String strNoteID = entry.getKey();
            if (!objNote.getNoteID().equals(strNoteID)) continue;
            JFrame objNoteViewFrame = entry.getValue();
            if (!objNoteViewFrame.isFocused()) {
                objNoteViewFrame.toFront();
            }
            return true;
        }
        return false;
    }

    private void displayNoteViewDialog(BONote objNote) {
        if (!this.setNoteViewInFocus(objNote)) {
            NoteViewPanel objNoteViewPanel = new NoteViewPanel(this.nc, objNote);
            this.mNoteViewPanels.put(objNote.getNoteID(), objNoteViewPanel);
            JFrame objNoteViewFrame = new JFrame("My Notebook View Note");
            this.mNoteViewFrames.put(objNote.getNoteID(), objNoteViewFrame);
            objNoteViewFrame.getContentPane().add((Component)objNoteViewPanel, "Center");
            objNoteViewFrame.pack();
            objNoteViewFrame.setLocationRelativeTo(null);
            objNoteViewFrame.setDefaultCloseOperation(0);
            objNoteViewFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    String strNoteID = null;
                    JFrame objCloseFrame = (JFrame)evt.getWindow();
                    for (Map.Entry entry : NotesTabPanel.this.mNoteViewFrames.entrySet()) {
                        JFrame objOpenFrame = (JFrame)entry.getValue();
                        if (!objCloseFrame.equals(objOpenFrame)) continue;
                        strNoteID = (String)entry.getKey();
                        break;
                    }
                    if (strNoteID != null) {
                        NotesTabPanel.this.disposeNoteViewDialog(strNoteID);
                    }
                }
            });
            objNoteViewFrame.setVisible(true);
            this.nc.addView(objNoteViewPanel);
        }
    }

    private void disposeNoteViewDialog(String strDisposeNoteID) {
        String strNoteID;
        for (Map.Entry<String, JFrame> entry : this.mNoteViewFrames.entrySet()) {
            strNoteID = entry.getKey();
            if (!strDisposeNoteID.equals(strNoteID)) continue;
            JFrame objNoteViewFrame = entry.getValue();
            if (objNoteViewFrame != null) {
                objNoteViewFrame.setVisible(false);
                objNoteViewFrame.dispose();
            }
            this.mNoteViewFrames.remove(strNoteID);
            break;
        }
        for (Map.Entry<String, Container> entry : this.mNoteViewPanels.entrySet()) {
            strNoteID = entry.getKey();
            if (!strDisposeNoteID.equals(strNoteID)) continue;
            NoteViewPanel objNoteViewPanel = (NoteViewPanel)entry.getValue();
            if (objNoteViewPanel != null) {
                this.nc.removeView(objNoteViewPanel);
            }
            this.mNoteViewPanels.remove(strNoteID);
            break;
        }
    }

    private void disposeNoteViewDialogs() {
        String strNoteID;
        for (Map.Entry<String, JFrame> entry : this.mNoteViewFrames.entrySet()) {
            strNoteID = entry.getKey();
            JFrame objNoteViewFrame = entry.getValue();
            if (objNoteViewFrame == null) continue;
            objNoteViewFrame.setVisible(false);
            objNoteViewFrame.dispose();
        }
        this.mNoteViewFrames.clear();
        for (Map.Entry<String, Container> entry : this.mNoteViewPanels.entrySet()) {
            strNoteID = entry.getKey();
            NoteViewPanel objNoteViewPanel = (NoteViewPanel)entry.getValue();
            if (objNoteViewPanel == null) continue;
            this.nc.removeView(objNoteViewPanel);
        }
        this.mNoteViewPanels.clear();
    }

    private void actionAddNote() {
        this.displayAddNoteDialog();
    }

    private void actionDeleteNote() {
        int iReturn;
        this.disposeAddNoteDialog();
        int idx = this.jListNotes.getSelectedIndex();
        if (idx != -1 && (iReturn = this.displayOptionDialog("Are you sure you want to delete the selected note?")) == 0) {
            BONotebookNote objNotebookNote = (BONotebookNote)this.nlm.getElementAt(idx);
            this.nc.deleteNote(objNotebookNote);
        }
    }

    @Override
    public void modelPropertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "CreateTab": {
                this.modelPropCreateTab(evt);
                break;
            }
            case "ReadTab": {
                this.modelPropReadTab(evt);
                break;
            }
            case "UpdateTab": {
                this.modelPropUpdateTab(evt);
                break;
            }
            case "DeleteTab": {
                this.modelPropDeleteTab(evt);
                break;
            }
            case "CloseTab": {
                this.modelPropCloseTab(evt);
                break;
            }
            case "CreateNote": {
                this.modelPropCreateNote(evt);
                break;
            }
            case "ReadNote": {
                this.modelPropReadNote(evt);
                break;
            }
            case "UpdateNote": {
                this.modelPropUpdateNote(evt);
                break;
            }
            case "DeleteNote": {
                this.modelPropDeleteNote(evt);
                break;
            }
            case "CloseNote": {
                this.modelPropCloseNote(evt);
                break;
            }
            case "CancelNote": {
                this.modelPropCancelNote(evt);
            }
        }
        this.revalidate();
        this.repaint();
    }

    private void modelPropCreateTab(PropertyChangeEvent evt) {
    }

    private void modelPropReadTab(PropertyChangeEvent evt) {
        ModelContext objContext = (ModelContext)evt.getOldValue();
        String message = (String)objContext.getProperty("MODEL_CTX_MSG");
        if (!message.equals("NOMSG")) {
            return;
        }
        BONotebookTab objSelectedTab = (BONotebookTab)objContext.getProperty("MODEL_CTX_A");
        if (this.objTab.getNotebookTabID().equals(objSelectedTab.getNotebookTabID())) {
            ArrayList aNotebookNotes = (ArrayList)objContext.getProperty("MODEL_CTX_B");
            this.addNotesToTab(aNotebookNotes);
        }
    }

    private void modelPropUpdateTab(PropertyChangeEvent evt) {
    }

    private void modelPropDeleteTab(PropertyChangeEvent evt) {
        ModelContext objContext = (ModelContext)evt.getOldValue();
        String message = (String)objContext.getProperty("MODEL_CTX_MSG");
        if (!message.equals("NOMSG")) {
            return;
        }
        BONotebookTab objClosedTab = (BONotebookTab)objContext.getProperty("MODEL_CTX_A");
        if (this.objTab.getNotebookTabID().equals(objClosedTab.getNotebookTabID())) {
            this.disposeNoteViewDialogs();
        }
    }

    private void modelPropCloseTab(PropertyChangeEvent evt) {
        ModelContext objContext = (ModelContext)evt.getOldValue();
        String message = (String)objContext.getProperty("MODEL_CTX_MSG");
        if (!message.equals("NOMSG")) {
            return;
        }
        BONotebookTab objClosedTab = (BONotebookTab)objContext.getProperty("MODEL_CTX_A");
        if (this.objTab.getNotebookTabID().equals(objClosedTab.getNotebookTabID())) {
            this.disposeNoteViewDialogs();
        }
    }

    private void modelPropCreateNote(PropertyChangeEvent evt) {
        this.disposeAddNoteDialog();
        ModelContext objContext = (ModelContext)evt.getOldValue();
        String message = (String)objContext.getProperty("MODEL_CTX_MSG");
        if (!message.equals("NOMSG")) {
            return;
        }
        BONotebookTab objNotebookTab = (BONotebookTab)objContext.getProperty("MODEL_CTX_A");
        if (objNotebookTab.getTabName().equals(this.objTab.getTabName())) {
            ArrayList aNotebookNotes = (ArrayList)objContext.getProperty("MODEL_CTX_B");
            this.addNotesToTab(aNotebookNotes);
        }
    }

    private void modelPropReadNote(PropertyChangeEvent evt) {
        ModelContext objContext = (ModelContext)evt.getOldValue();
        String message = (String)objContext.getProperty("MODEL_CTX_MSG");
        if (!message.equals("NOMSG")) {
            return;
        }
        BONote objNote = (BONote)objContext.getProperty("MODEL_CTX_A");
        if (objNote.getTab().equals(this.objTab.getTabName())) {
            this.displayNoteViewDialog(objNote);
        }
    }

    private void modelPropUpdateNote(PropertyChangeEvent evt) {
    }

    private void modelPropDeleteNote(PropertyChangeEvent evt) {
        ModelContext objContext = (ModelContext)evt.getOldValue();
        String message = (String)objContext.getProperty("MODEL_CTX_MSG");
        if (!message.equals("NOMSG")) {
            return;
        }
        BONotebookTab objNotebookTab = (BONotebookTab)objContext.getProperty("MODEL_CTX_A");
        BONotebookNote objNotebookNote = (BONotebookNote)objContext.getProperty("MODEL_CTX_C");
        if (objNotebookTab.getTabName().equals(this.objTab.getTabName())) {
            this.disposeNoteViewDialog(objNotebookNote.getNoteId());
            ArrayList aNotebookNotes = (ArrayList)objContext.getProperty("MODEL_CTX_B");
            this.addNotesToTab(aNotebookNotes);
        }
    }

    private void modelPropCloseNote(PropertyChangeEvent evt) {
        ModelContext objContext = (ModelContext)evt.getOldValue();
        String message = (String)objContext.getProperty("MODEL_CTX_MSG");
        if (!message.equals("NOMSG")) {
            return;
        }
        BONote objNote = (BONote)objContext.getProperty("MODEL_CTX_A");
        if (objNote.getTab().equals(this.objTab.getTabName())) {
            this.disposeNoteViewDialog(objNote.getNoteID());
        }
    }

    private void modelPropCancelNote(PropertyChangeEvent evt) {
        ModelContext objContext = (ModelContext)evt.getOldValue();
        String message = (String)objContext.getProperty("MODEL_CTX_MSG");
        if (!message.equals("NOMSG")) {
            return;
        }
        this.disposeAddNoteDialog();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jButtonAddNote = new JButton();
        this.jButtonDeleteNote = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jListNotes = new JList();
        this.setMaximumSize(new Dimension(500, 500));
        this.setMinimumSize(new Dimension(100, 100));
        this.setPreferredSize(new Dimension(350, 200));
        this.jLabel1.setText("Notes");
        this.jButtonAddNote.setText("Add Note");
        this.jButtonAddNote.setMaximumSize(new Dimension(100, 25));
        this.jButtonAddNote.setMinimumSize(new Dimension(100, 25));
        this.jButtonAddNote.setPreferredSize(new Dimension(100, 25));
        this.jButtonAddNote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesTabPanel.this.actionPerformed(evt);
            }
        });
        this.jButtonDeleteNote.setText("Delete Note");
        this.jButtonDeleteNote.setMaximumSize(new Dimension(100, 25));
        this.jButtonDeleteNote.setMinimumSize(new Dimension(100, 25));
        this.jButtonDeleteNote.setPreferredSize(new Dimension(100, 25));
        this.jButtonDeleteNote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesTabPanel.this.actionPerformed(evt);
            }
        });
        this.jListNotes.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jListNotes.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                NotesTabPanel.this.valueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListNotes);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.jScrollPane1, -1, 330, Short.MAX_VALUE).add(layout.createSequentialGroup().add(this.jButtonAddNote, -2, -1, -2).addPreferredGap(0).add(this.jButtonDeleteNote, -2, -1, -2)).add(this.jLabel1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jLabel1).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jButtonAddNote, -2, -1, -2).add(this.jButtonDeleteNote, -2, -1, -2)).addPreferredGap(0).add(this.jScrollPane1, -1, 127, Short.MAX_VALUE).addContainerGap()));
    }

    private void valueChanged(ListSelectionEvent evt) {
        int idx;
        if (!evt.getValueIsAdjusting() && (idx = this.jListNotes.getSelectedIndex()) != -1) {
            BONotebookNote objNotebookNote = (BONotebookNote)this.nlm.getElementAt(idx);
            this.nc.readNote(objNotebookNote);
        }
    }

    private void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.jButtonAddNote) {
            this.actionAddNote();
        } else if (evt.getSource() == this.jButtonDeleteNote) {
            this.actionDeleteNote();
        }
    }
}

