/*
 * Decompiled with CFR 0.152.
 */
package fof.bo;

import fof.bo.BusinessObject;
import java.util.Map;

public class BusinessObjectSequence
extends BusinessObject {
    private static final int intMax = Integer.MAX_VALUE;
    private String strSeqName;
    private static final String strSeqNameName = "SEQ_NAME";
    private static final int intSeqNameLength = 10;
    private static final boolean bSeqNameEncoded = false;
    private String strSeqStart;
    private static final String strSeqStartName = "SEQ_START";
    private static final int intSeqStartLength = 10;
    private static final boolean bSeqStartEncoded = false;
    private String strSeqMax;
    private static final String strSeqMaxName = "SEQ_MAX";
    private static final int intSeqMaxLength = 10;
    private static final boolean bSeqMaxEncoded = false;
    private String strSeqIncr;
    private static final String strSeqIncrName = "SEQ_INCR";
    private static final int intSeqIncrLength = 10;
    private static final boolean bSeqIncrEncoded = false;
    private String strSeqValue;
    private static final String strSeqValueName = "SEQ_VALUE";
    private static final int intSeqValueLength = 10;
    private static final boolean bSeqValueEncoded = false;

    public BusinessObjectSequence(String strLineType) {
        this.setLineType(strLineType);
    }

    public BusinessObjectSequence(String strLineType, String strSeqName, String strSeqStart, String strSeqMax, String strSeqIncr, String strSeqValue) {
        this.setLineType(strLineType);
        this.setSeqName(strSeqName);
        this.setSeqStart(strSeqStart);
        this.setSeqMax(strSeqMax);
        this.setSeqIncr(strSeqIncr);
        this.setSeqValue(strSeqValue);
    }

    public String getSeqName() {
        return this.strSeqName;
    }

    public void setSeqName(String strSeqName) {
        this.strSeqName = BusinessObjectSequence.truncateAttr(strSeqName, 10).trim();
    }

    public String getSeqStart() {
        return this.strSeqStart;
    }

    public void setSeqStart(String strSeqStart) {
        this.strSeqStart = this.checkIntMax(BusinessObjectSequence.truncateAttr(strSeqStart, 10).trim());
    }

    public String getSeqMax() {
        return this.strSeqMax;
    }

    public void setSeqMax(String strSeqMax) {
        this.strSeqMax = this.checkIntMax(BusinessObjectSequence.truncateAttr(strSeqMax, 10).trim());
    }

    public String getSeqIncr() {
        return this.strSeqIncr;
    }

    public void setSeqIncr(String strSeqIncr) {
        this.strSeqIncr = this.checkIntMax(BusinessObjectSequence.truncateAttr(strSeqIncr, 10).trim());
    }

    public String getSeqValue() {
        return this.strSeqValue;
    }

    public void setSeqValue(String strSeqValue) {
        String strTemp = this.checkIntMax(BusinessObjectSequence.truncateAttr(strSeqValue, 10).trim());
        this.strSeqValue = String.format("%10s", strTemp).replaceAll(" ", "0");
    }

    public String getNextSeqValue() {
        long lngSeqMax = new Long(this.strSeqMax);
        long lngSeqIncr = new Long(this.strSeqIncr);
        long lngSeqValue = new Long(this.strSeqValue);
        long lngNextSeqValue = lngSeqValue + lngSeqIncr;
        if (lngNextSeqValue > lngSeqMax) {
            this.resetSeq();
        } else {
            this.setSeqValue(new Long(lngNextSeqValue).toString());
        }
        return this.getSeqValue();
    }

    public void resetSeq() {
        this.setSeqValue(this.strSeqStart);
    }

    private String checkIntMax(String strValue) {
        long lngValue = new Long(strValue);
        if (lngValue > Integer.MAX_VALUE) {
            return new Integer(Integer.MAX_VALUE).toString();
        }
        return strValue;
    }

    @Override
    public Map<String, Map<String, Object>> getMapOfAttrValues() {
        this.initAttrMap();
        this.addAttrToMap(strSeqNameName, this.getSeqName(), 10, this.getNextLineFieldIdx(), false);
        this.addAttrToMap(strSeqStartName, this.getSeqStart(), 10, this.getNextLineFieldIdx(), false);
        this.addAttrToMap(strSeqMaxName, this.getSeqMax(), 10, this.getNextLineFieldIdx(), false);
        this.addAttrToMap(strSeqIncrName, this.getSeqIncr(), 10, this.getNextLineFieldIdx(), false);
        this.addAttrToMap(strSeqValueName, this.getSeqValue(), 10, this.getNextLineFieldIdx(), false);
        return this.getAttrMap();
    }

    @Override
    public void setMapOfAttrValues(Map<String, String> mapAttrValues) {
        for (Map.Entry<String, String> entry : mapAttrValues.entrySet()) {
            String mapKey = entry.getKey();
            String mapValue = entry.getValue();
            switch (mapKey) {
                case "SEQ_NAME": {
                    this.setSeqName(mapValue);
                    break;
                }
                case "SEQ_START": {
                    this.setSeqStart(mapValue);
                    break;
                }
                case "SEQ_MAX": {
                    this.setSeqMax(mapValue);
                    break;
                }
                case "SEQ_INCR": {
                    this.setSeqIncr(mapValue);
                    break;
                }
                case "SEQ_VALUE": {
                    this.setSeqValue(mapValue);
                }
            }
        }
    }
}

