/*
 * Decompiled with CFR 0.152.
 */
package fof.file;

import fof.bo.BusinessObject;
import fof.bo.BusinessObjectMgr;
import fof.file.FOEncoder;
import fof.file.FOFile;
import fof.file.FOFileLine;
import fof.file.FOFileLineField;
import fof.file.FOFileLineFieldClob;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

public class FOFileMgr {
    private String strFilePath;
    private FOEncoder objEncoder;
    private int intLineTypeLength = 4;
    private int intClobFieldLength = 500;

    public FOFileMgr() {
        this.strFilePath = null;
        this.objEncoder = null;
    }

    public FOFileMgr(String strFilePath) {
        this.setFilePath(strFilePath);
        this.objEncoder = null;
    }

    public String getFOFVersion() {
        return "1.3";
    }

    public String getFilePath() {
        return this.strFilePath;
    }

    public void setFilePath(String strFilePath) {
        char lastChar;
        if (strFilePath != null && !strFilePath.isEmpty() && File.separatorChar != (lastChar = strFilePath.charAt(strFilePath.length() - 1))) {
            strFilePath = strFilePath + File.separatorChar;
        }
        this.strFilePath = strFilePath;
    }

    public FOEncoder getEncoder() {
        return this.objEncoder;
    }

    public void setEncoder(FOEncoder objEncoder) {
        this.objEncoder = objEncoder;
    }

    public int getLineTypeLength() {
        return this.intLineTypeLength;
    }

    public void setLineTypeLength(int intLineTypeLength) {
        this.intLineTypeLength = intLineTypeLength;
    }

    public int getClobFieldLength() {
        return this.intClobFieldLength;
    }

    public void setClobFieldLength(int intClobFieldLength) {
        this.intClobFieldLength = intClobFieldLength;
    }

    public boolean verifyFilePath(FOFile objFile) {
        File fFile = new File(this.getFilePath() + objFile.getFileDirectory());
        if (!fFile.exists()) {
            return fFile.mkdirs();
        }
        if (!fFile.canWrite()) {
            return false;
        }
        return fFile.canRead();
    }

    public boolean verifyFileExists(FOFile objFile) {
        File fFile = new File(this.getFilePath() + objFile.getFileDirectory() + objFile.getFileName());
        return fFile.exists();
    }

    protected String getNowTimeStamp() {
        Date now = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd-HH:mm:ss");
        String date = df.format(now);
        return date;
    }

    protected String getEmptyString(int intLength) {
        String strEmptyString;
        char chFillCh = ' ';
        if (intLength > 0) {
            char[] chArray = new char[intLength];
            Arrays.fill(chArray, chFillCh);
            strEmptyString = new String(chArray);
        } else {
            strEmptyString = "";
        }
        return strEmptyString;
    }

    protected String encodeString(String strValue) {
        String strEncodedValue = strValue;
        if (this.objEncoder != null) {
            strEncodedValue = this.objEncoder.encodeString(strValue);
        }
        return strEncodedValue;
    }

    protected String decodeString(String strValue) {
        String strDecodedValue = strValue;
        if (this.objEncoder != null) {
            strDecodedValue = this.objEncoder.decodeString(strValue);
        }
        return strDecodedValue;
    }

    public void addFileLineToFile(BusinessObject objBO, FOFile objFile) {
        Map<String, Object> mapAttrValues;
        String strAttrName;
        int intPos = 0;
        FOFileLine objFileLine = new FOFileLine();
        Map<String, Map<String, Object>> mapAttrs = objBO.getMapOfAttrValues();
        TreeMap<Integer, String> mapOrderedAttrs = new TreeMap<Integer, String>();
        for (Map.Entry<String, Map<String, Object>> entry : mapAttrs.entrySet()) {
            strAttrName = entry.getKey();
            mapAttrValues = entry.getValue();
            int intAttrOrder = (Integer)mapAttrValues.get(objBO.getAttrOrderName());
            mapOrderedAttrs.put(intAttrOrder, strAttrName);
        }
        for (Map.Entry<String, Map<String, Object>> entry : mapOrderedAttrs.entrySet()) {
            strAttrName = (String)((Object)entry.getValue());
            mapAttrValues = mapAttrs.get(strAttrName);
            int intAttrLength = (Integer)mapAttrValues.get(objBO.getAttrLengthName());
            int intAttrOrder = (Integer)mapAttrValues.get(objBO.getAttrOrderName());
            boolean bEncoded = (Boolean)mapAttrValues.get(objBO.getAttrEncodeName());
            if (intAttrLength < this.getClobFieldLength()) {
                int intStartPos = intPos;
                intPos = intStartPos + intAttrLength;
                objFileLine.addFileLineField(new FOFileLineField(strAttrName, intAttrLength, intAttrOrder, intStartPos, intPos, bEncoded));
                ++intPos;
                continue;
            }
            objFileLine.addFileLineClobField(new FOFileLineFieldClob(strAttrName, intAttrLength, intAttrOrder, 0, 0, bEncoded));
        }
        objFileLine.setFileLineType(objBO.getLineType());
        objFileLine.setLineLength(intPos);
        objFile.addFileLine(objFileLine);
    }

    public void writeFile(BusinessObjectMgr objBOMgr, FOFile objFile, boolean bWriteLineHeader, boolean bAppendFile) throws IOException {
        boolean bFileExists = this.verifyFileExists(objFile);
        if (bAppendFile && bWriteLineHeader) {
            bWriteLineHeader = !bFileExists;
        }
        String strLineSep = System.lineSeparator();
        File objFileOut = new File(this.strFilePath + objFile.getFileDirectory() + objFile.getFileName());
        FileWriter objFileWriter = new FileWriter(objFileOut, bAppendFile);
        BufferedWriter objBWOut = new BufferedWriter(objFileWriter);
        ArrayList aFileLines = objFile.getFileLines();
        for (FOFileLine objFileLine : aFileLines) {
            boolean bWriteLineHeaderCont = bWriteLineHeader;
            String strFileLineType = objFileLine.getFileLineType();
            String strFieldSep = objFileLine.getFieldSeparator();
            StringBuilder strWriteLine = new StringBuilder(this.getEmptyString(objFileLine.getLineLength()));
            ArrayList<FOFileLineField> aFileLineFields = objFileLine.getFileLineFields();
            Collections.sort(aFileLineFields);
            ArrayList<FOFileLineFieldClob> aFileLineClobFields = objFileLine.getFileLineClobFields();
            Collections.sort(aFileLineClobFields);
            ArrayList<BusinessObject> aBOs = objBOMgr.getBusinessObjectsOfLineType(strFileLineType);
            for (BusinessObject objBO : aBOs) {
                String strFieldValue;
                Map<String, Object> mapAttrValues;
                if (bWriteLineHeader && bWriteLineHeaderCont) {
                    for (FOFileLineField objFileLineField : aFileLineFields) {
                        String strFieldName = objFileLineField.getFieldName();
                        strWriteLine.replace(objFileLineField.getFieldStartPos(), objFileLineField.getFieldEndPos(), String.format("%-" + objFileLineField.getFieldLength() + "s", strFieldName));
                        strWriteLine.replace(objFileLineField.getFieldEndPos(), objFileLineField.getFieldEndPos() + 1, strFieldSep);
                    }
                    objBWOut.write(strWriteLine.toString() + strLineSep);
                    for (FOFileLineField objFileLineField : aFileLineFields) {
                        strWriteLine.replace(objFileLineField.getFieldStartPos(), objFileLineField.getFieldEndPos(), String.format("%" + objFileLineField.getFieldLength() + "s", "").replaceAll("(?s).", "-"));
                        strWriteLine.replace(objFileLineField.getFieldEndPos(), objFileLineField.getFieldEndPos() + 1, strFieldSep);
                    }
                    objBWOut.write(strWriteLine.toString() + strLineSep);
                }
                Map<String, Map<String, Object>> mapAttrs = objBO.getMapOfAttrValues();
                for (FOFileLineField objFileLineField : aFileLineFields) {
                    String fieldName = objFileLineField.getFieldName();
                    mapAttrValues = mapAttrs.get(fieldName);
                    strFieldValue = (String)mapAttrValues.get(objBO.getAttrValueName());
                    if (objFileLineField.isEncoded()) {
                        strFieldValue = this.encodeString(strFieldValue);
                    }
                    strWriteLine.replace(objFileLineField.getFieldStartPos(), objFileLineField.getFieldEndPos(), String.format("%-" + objFileLineField.getFieldLength() + "s", strFieldValue));
                    strWriteLine.replace(objFileLineField.getFieldEndPos(), objFileLineField.getFieldEndPos() + 1, strFieldSep);
                }
                objBWOut.write(strWriteLine.toString() + strLineSep);
                for (FOFileLineFieldClob objFileLineClobField : aFileLineClobFields) {
                    String strFieldName = objFileLineClobField.getFieldName();
                    mapAttrValues = mapAttrs.get(strFieldName);
                    strFieldValue = (String)mapAttrValues.get(objBO.getAttrValueName());
                    objBWOut.write(strLineSep);
                    if (bWriteLineHeader && bWriteLineHeaderCont) {
                        objBWOut.write(strFieldName + strLineSep);
                        StringBuilder strFieldNameDash = new StringBuilder(this.getEmptyString(strFieldName.length()));
                        strFieldNameDash.replace(objFileLineClobField.getFieldStartPos(), objFileLineClobField.getFieldEndPos(), String.format("%" + strFieldName.length() + "s", "").replaceAll("(?s).", "-"));
                        objBWOut.write(strFieldNameDash.toString() + strLineSep);
                    }
                    if (objFileLineClobField.isEncoded()) {
                        strFieldValue = this.encodeString(strFieldValue);
                    }
                    objBWOut.write(objFileLineClobField.getClobFieldBeginCode() + strLineSep);
                    objBWOut.write(strFieldValue + strLineSep);
                    objBWOut.write(objFileLineClobField.getClobFieldEndCode() + strLineSep);
                    objBWOut.write(strLineSep);
                }
                bWriteLineHeaderCont = !aFileLineClobFields.isEmpty();
            }
            if (bAppendFile) continue;
            objBWOut.write(strLineSep);
        }
        objBWOut.close();
    }

    public void writeFileCSV(BusinessObjectMgr objBOMgr, FOFile objFile, boolean bWriteLineHeader, boolean bAppendFile) throws IOException {
        TreeMap<String, String> mapOrigFieldSeparators = new TreeMap<String, String>();
        ArrayList aFileLines = objFile.getFileLines();
        for (FOFileLine objFileLine : aFileLines) {
            mapOrigFieldSeparators.put(objFileLine.getFileLineType(), objFileLine.getFieldSeparator());
            objFileLine.setFieldSeparator(",");
        }
        this.writeFile(objBOMgr, objFile, bWriteLineHeader, bAppendFile);
        for (FOFileLine objFileLine : aFileLines) {
            String strOrigFieldSeparator = (String)mapOrigFieldSeparators.get(objFileLine.getFileLineType());
            objFileLine.setFieldSeparator(strOrigFieldSeparator);
        }
    }

    public void readFile(BusinessObjectMgr objBOMgr, FOFile objFile) throws IOException {
        String strLine;
        File objFileIn = new File(this.strFilePath + objFile.getFileDirectory() + objFile.getFileName());
        FileReader objFileReader = new FileReader(objFileIn);
        BufferedReader objBRIn = new BufferedReader(objFileReader);
        TreeMap<String, FOFileLine> mapFileLines = new TreeMap<String, FOFileLine>();
        ArrayList aFileLines = objFile.getFileLines();
        for (FOFileLine objFileLine : aFileLines) {
            mapFileLines.put(objFileLine.getFileLineType(), objFileLine);
        }
        while ((strLine = objBRIn.readLine()) != null) {
            String strLineType;
            FOFileLine objFileLine;
            if (strLine.length() < this.getLineTypeLength() || (objFileLine = (FOFileLine)mapFileLines.get(strLineType = strLine.substring(0, this.getLineTypeLength()))) == null) continue;
            TreeMap<String, String> mapFieldValues = new TreeMap<String, String>();
            ArrayList<FOFileLineField> aFileLineFields = objFileLine.getFileLineFields();
            Collections.sort(aFileLineFields);
            for (FOFileLineField objFileLineField : aFileLineFields) {
                String strFieldName = objFileLineField.getFieldName();
                String strFieldValue = strLine.substring(objFileLineField.getFieldStartPos(), objFileLineField.getFieldEndPos());
                if (objFileLineField.isEncoded()) {
                    strFieldValue = this.decodeString(strFieldValue);
                }
                mapFieldValues.put(strFieldName, strFieldValue);
            }
            ArrayList<FOFileLineFieldClob> aFileLineClobFields = objFileLine.getFileLineClobFields();
            Collections.sort(aFileLineClobFields);
            for (FOFileLineFieldClob objFileLineClobField : aFileLineClobFields) {
                String strFieldName = objFileLineClobField.getFieldName();
                String strFieldValue = new String();
                while ((strLine = objBRIn.readLine()) != null) {
                    if (!strLine.trim().equals(objFileLineClobField.getClobFieldBeginCode())) continue;
                    StringBuilder strClobValue = new StringBuilder();
                    while ((strLine = objBRIn.readLine()) != null && !strLine.trim().equals(objFileLineClobField.getClobFieldEndCode())) {
                        strClobValue.append(strLine).append('\n');
                    }
                    strFieldValue = strClobValue.toString().trim();
                    break;
                }
                if (objFileLineClobField.isEncoded()) {
                    strFieldValue = this.decodeString(strFieldValue);
                }
                mapFieldValues.put(strFieldName, strFieldValue);
            }
            objBOMgr.addBusinessObject(strLineType, mapFieldValues);
        }
        objBRIn.close();
    }
}

